#!/bin/sh

# This is a convenience script that works around some limitations in
# the current dbus-binding-tool. It will probably become unnecessary
# in the future.

INTERFACES=(
"Channel tp-chan"
"Channel.Interface.DTMF tp-chan-iface-dtmf"
"Channel.Interface.Group tp-chan-iface-group"
"Channel.Interface.Hold tp-chan-iface-hold"
"Channel.Interface.Password tp-chan-iface-password"
"Channel.Interface.Subject tp-chan-iface-subject"
"Channel.Interface.Transfer tp-chan-iface-transfer"
"Channel.Type.ContactList tp-chan-type-contact-list"
#"Channel.Type.ContactSearch tp-chan-type-contact-search"
"Channel.Type.RoomList tp-chan-type-room-list"
"Channel.Type.StreamedMedia tp-chan-type-streamed-media"
"Channel.Type.Text tp-chan-type-text"
"ChannelHandler tp-ch"
"Connection tp-conn"
"Connection.Interface.Aliasing tp-conn-iface-aliasing"
"Connection.Interface.Capabilities tp-conn-iface-capabilities"
"Connection.Interface.ContactInfo tp-conn-iface-contact-info"
"Connection.Interface.Forwarding tp-conn-iface-forwarding"
"Connection.Interface.Presence tp-conn-iface-presence"
"Connection.Interface.Privacy tp-conn-iface-privacy"
"Connection.Interface.Renaming tp-conn-iface-renaming"
"ConnectionManager tp-connmgr"
"Properties tp-props-iface")
    
ANT="    \<annotation name=\"org.freedesktop.DBus.GLib.ClientCSymbol\" value="

for (( i = 0; i < ${#INTERFACES[@]} ; i++))
do
    set -- ${INTERFACES[$i]}
    IF_NAME=$1;
    IF_FILE=$2;

    IF_UNAME=`echo $IF_FILE |sed s/-/_/g`
    IF_BASE=`echo $IF_NAME |cut -f1 -d.`

# strip the DBus introspec definition   
    perl -ne '$/=undef; s/<interface name.*DBus.*>(.|\n)*?<\/interface>//; print "$_"' $top_srcdir/xml/orig/$IF_FILE.xml > $top_builddir/xml/$IF_FILE.xml


# strip the redefinition of the channel base interface
    if [ "$IF_BASE" != "$IF_NAME" ]; then
        perl -ni -e '$/=undef; s/<interface name.*'$IF_BASE'.>(.|\n)*?<\/interface>//; print "$_"' $top_builddir/xml/$IF_FILE.xml
    fi  

# add the annotation tag
    sed -i s/org.freedesktop.Telepathy.$IF_BASE.*$/\&\\n"$ANT\"$IF_UNAME\"\/\>"/ $top_builddir/xml/$IF_FILE.xml

done

