/* proto.c
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */


#ifndef DBUS_API_SUBJECT_TO_CHANGE
#define DBUS_API_SUBJECT_TO_CHANGE
#endif



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib.h>
#include <glib.h>
#include "tp-conn.h"
#include "tp-connmgr.h"
#include "tp-chan.h"
#include "tp-chan-gen.h"
#include "tp-chan-iface-group-gen.h"
#include "tp-chan-type-text-gen.h"
#include "tp-interfaces.h"

/*
 * Test connection manager and account
 */
#define CONNMGR_PATH "/usr/share/telepathy/services/swiss.cmanager"
#define TEXT_CHANNEL "org.freedesktop.Telepathy.Channel.Type.Text"
#define PROTOCOL "jabber"


static gboolean connected = FALSE;
gboolean channel_done = FALSE;

#if 0
static gint find_group_if(gchar *iface,
			  gchar *group_iface);
#endif

static void newconnection_handler(DBusGProxy *proxy, const char *s1,
				  const char *o, const char *s2,
				  gpointer user_data);

static void newchannel_handler(DBusGProxy *proxy, const char *object_path,
			       const char *channel_type, guint handle_type,
			       guint handle, gboolean suppress_handle,
			       gpointer user_data);

static gboolean status_changed_cb(DBusGProxy *proxy,
				  guint status, guint reason,
				  gpointer user_data);

int main(int argc, char **argv)
{
	DBusGConnection *connection;
	DBusGProxy *text_if = NULL;
	GError *error = NULL;
	TpConnMgr *connmgr;
        TpConn *conn;
	TpChan *chan1;
	guint status = 1;

	gchar *group_if_name =
	  g_strdup("org.freedesktop.Telepathy.Channel.Interface.Group");
	GValue val_acc, val_auth_usr, val_auth_realm, val_auth_type, val_pwd;
	GHashTable *connection_parameters = g_hash_table_new(g_str_hash, NULL);

	GKeyFile *cm_file = g_key_file_new();
	char *cm_name, *bus_name, *obj_path;
	GMainLoop *mainloop;
	GPtrArray *msglist = NULL;
	
	g_type_init();
	mainloop = g_main_loop_new (NULL, FALSE);

	connection = dbus_g_bus_get(DBUS_BUS_SESSION, &error);
	if (connection == NULL) {
		g_printerr("Failed to open connection to bus: %s\n",
			   error->message);
		g_error_free(error);
		exit(1);
	}
	printf("connection : %p\n", connection);

  gchar *srcdir = getenv ("srcdir");
  gchar *cm_path = "config/swiss.cmanager";

  if (srcdir)
      cm_path = g_strconcat (srcdir, "/", cm_path, NULL);

  printf ("file : %s\n", cm_path);

	/* Handle .cmanager file */
	if (!(g_key_file_load_from_file(cm_file, cm_path,
					G_KEY_FILE_NONE, &error))) 
	  {
	    /* handle error */
	    g_printerr("%s\n", error->message);
	    g_error_free(error);
	    exit(1);
	}
	if (!(cm_name = g_key_file_get_string(cm_file, "ConnectionManager",
					      "Name", &error)))
	  {
	  /* Handle error */
	  g_printerr("%s\n", error->message);
	  g_error_free(error);
	  g_key_file_free(cm_file);
	  exit(1);
	}
	if ( !(bus_name = g_key_file_get_string(cm_file, "ConnectionManager",
						"BusName", &error)))
	  {
	    /* handle error */
	    g_printerr("%s\n", error->message);
	    g_free(cm_name);
	    g_error_free(error);
	    g_key_file_free(cm_file);
	    exit(1);
	  }
	fprintf(stderr, "Bus name: %s\n", bus_name);
	if ( !(obj_path = g_key_file_get_string(cm_file, "ConnectionManager",
						"ObjectPath", &error)))
	  {
	  /* handle error */
	  g_printerr("%s\n", error->message);
	  g_error_free(error);
	  g_free(cm_name);
	  g_free(bus_name);
	  g_key_file_free(cm_file);
	  exit(1);
	}

        /* Create a connection manager object */
	g_print("Attempting to create a connection manager object.\n");
        connmgr = tp_connmgr_new(connection, bus_name, obj_path,
				 TP_IFACE_CONN_MGR_INTERFACE);

	if (connmgr == NULL)
	  {
	    g_error("Failed to create a connection manager.");
	    g_key_file_free(cm_file);
	    exit(1);
	  }

	g_print("Creating a connection manager succeeded.\n");

	g_print("Attempting to register a signal handler for NewConnection signal.\n");
	dbus_g_proxy_connect_signal(DBUS_G_PROXY(connmgr), "NewConnection",
				    G_CALLBACK(newconnection_handler),
				    NULL, NULL);
	
	/* Setting "g_type" is a hack since GValue is broken */
	val_acc.g_type = 0;
	val_auth_usr.g_type = 0;
	val_auth_realm.g_type = 0;
	val_auth_type.g_type = 0;
	val_pwd.g_type = 0;

	g_value_init(&val_acc, G_TYPE_STRING);
	g_value_init(&val_auth_usr, G_TYPE_STRING);
	g_value_init(&val_auth_realm, G_TYPE_STRING);
	g_value_init(&val_auth_type, G_TYPE_STRING);
	g_value_init(&val_pwd, G_TYPE_STRING);

	/* Connection parameters are dummy: fill in suitable replacements */

	g_value_set_string(&val_acc, "user@jabbernet.dk");
	g_value_set_string(&val_auth_usr, "user");
	g_value_set_string(&val_pwd, "password");
	
	g_hash_table_insert(connection_parameters, "account",
			    (gpointer) &val_acc);
	/*	g_hash_table_insert(connection_parameters, "authentication-username",
		(gpointer) &val_auth_usr); */
	/*
	g_hash_table_insert(connection_parameters, "authentication-realm",
			    (gpointer) &val_auth_realm);
	g_hash_table_insert(connection_parameters, "authentication-type",
			    (gpointer) &val_auth_type);
	*/
	g_hash_table_insert(connection_parameters, "password",
			    (gpointer) &val_pwd);

	/* Create a new actual connection with the connection manager */

	g_print("Attempting to create a connection object.\n");

	conn = tp_connmgr_new_connection(connmgr,
					 connection_parameters,
					 PROTOCOL);
	if (conn == NULL)
	  {
	    g_error("Failed to create a connection.\n");
	    exit (1);
	  }
	dbus_g_proxy_connect_signal(DBUS_G_PROXY(conn), "NewChannel",
				    G_CALLBACK(newchannel_handler),
				    NULL, NULL);
	g_print("Creation of a connection object succeeded.\n");


	/* FIXME: Due to signficant changes to the library, much of the
	   previous tests are discarded for now; bring this up-to-date */

	/* Check if connection is active; if not, add a callback
	 * for StatusChange signal */

	if (!tp_conn_get_status(DBUS_G_PROXY(conn), &status, &error) ||
	    status != 0)
	  {
	    g_warning("Could not get connection status/not connected yet.\n");
	    g_warning("Thus, adding a callback for monitoring\n");
	    dbus_g_proxy_connect_signal(DBUS_G_PROXY(conn), "StatusChanged",
					G_CALLBACK(status_changed_cb),
					NULL, NULL);
	    /* FIXME: Free the error */
	    
	  }

	/* Somewhat ugly, but this is just a tester after all... */

	while (connected == FALSE)
	  {
	    g_main_context_iteration(NULL, FALSE);
	  }
	
	/* Create a test channel */
	
	g_print("Attempting to create a channel object.\n");

	chan1 = tp_conn_new_channel(connection, conn,
				bus_name, TEXT_CHANNEL, 1, 1, TRUE);
	if (chan1 == NULL)
	  {
	    g_warning("Failed to create a channel (tp_chan) object.\n");
	    g_main_loop_run(mainloop);
	  }
	
	g_print("Creation of a channel object succeeded.\n");

	while (channel_done == FALSE)
	  {
	    g_main_context_iteration(NULL, FALSE);
	    g_print("Channel done: %i (false: %i)\n", channel_done, FALSE);
	  }

	/* Request for the text interface proxy object */
	
	text_if = tp_chan_get_interface(chan1,
					TELEPATHY_CHAN_IFACE_TEXT_QUARK);
	if (text_if == NULL)
	  {
	    g_print("Could not acquire text interface proxy for channel\n");
	  }
	else 
	  {
	    /* Attach a received text handler to the type interface proxy */
	    
	    dbus_g_proxy_add_signal(text_if, "Received", G_TYPE_UINT,
				    G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT,
				    G_TYPE_STRING, G_TYPE_INVALID);	    
	    g_print("Text interface proxy acquired. Attempting to call\n");
	    g_print("ListPendingMessages\n");
	    if (!tp_chan_type_text_list_pending_messages(text_if,
							  &msglist, &error))
	      {
		g_print("Error acquiring pending message list: %s.\n",
			error->message);
	      }
	    else
	      {
		g_print("Pending message call succeeded.\n");
	      }
	  }

#if 0

	/* Finally, check if the channel has a Group interface and
	   attempt to query the group flags from it. Obviously, failure
	   may just indicate that the interface is just not supported by
	   the other end...*/

	g_print("Attempting to perform a query by using the Group interface");
	
	chan_interfaces = (GSList *)
	  tp_chan_local_get_interface_objs(chan1);
	
	if (chan_interfaces == NULL)
	  {
	    g_error("Channel does not have interfaces.");
	    exit(1);
	  }
	
	group_interface = g_slist_find_custom(chan_interfaces,
					      group_if_name,
					      (GCompareFunc)find_group_if);

	/* Exiting main loop should free the things below
	   Main loop is entered to demonstrate signal listening */

	if (group_interface == NULL)
	  {
	    g_error("Did not find Group interface for the channel.");
	    exit(1);
	  }
	g_print("Group interface: %p\n", group_interface);

	if (!tp_chan_iface_group_get_group_flags((DBusGProxy *)group_interface->data, &group_flags, &error))
	  {
	    g_error("Querying group flags failed: %s\n", error->message);
	    g_error_free(error);
	    exit(1);
	  }

	g_print("Got group flags: %u\n", group_flags);

	tp_conn_request_channel (DBUS_G_PROXY(conn), "org.freedesktop.Telepathy.Channel.Type.StreamedMedia", 1, 1, TRUE, &foo, &error);
	g_print("error state: %s\n", error->message);

#endif
	g_main_loop_run (mainloop);

	/* TODO: Never reached */
	g_free(cm_name);
	g_free(bus_name);
	g_free(obj_path);
	g_free(group_if_name);
	g_key_file_free(cm_file);
	g_hash_table_destroy(connection_parameters);
	return 0;
}

static void newconnection_handler(DBusGProxy *proxy, const char *s1,
				  const char *o, const char *s2,
				  gpointer user_data)

{
  g_print("****newconnection_handler() got called: %s %s %s\n", s1, o, s2);
}


static void newchannel_handler(DBusGProxy *proxy, const char *object_path,
			       const char *channel_type, guint handle_type,
			       guint handle, gboolean suppress_handle,
			       gpointer user_data)
{
  g_print("****newchannel_handler() got called. Path: %s, type: %s\n",
	  object_path, channel_type);
  if (strcmp(channel_type, "org.freedesktop.Telepathy.Channel.Type.Text") == 0)
    {
      g_print("Match!\n");
      channel_done = TRUE;
    }
}

#if 0
static gint find_group_if(gchar *iface,
			  gchar *group_iface)
{
  DBusGProxy *if_proxy = (DBusGProxy *)iface;
  if (strcmp(dbus_g_proxy_get_interface(if_proxy), group_iface) == 0)
    {
      return 0;
    }
  return -1;
}
#endif

static gboolean status_changed_cb(DBusGProxy *proxy,
			      guint status, guint reason,
			      gpointer user_data)
{
  g_print("Status changed callback called.\n");
  if (status == 0)
    {
      g_print("Connected!\n");
      connected = TRUE;
    }
  else 
    {
      connected = FALSE;
    }
  return TRUE;
}
