/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __GST_DSPMPEG4SINK_H__
#define __GST_DSPMPEG4SINK_H__

#define MPEG4_MAX_FPS 30.0
#define MPEG4_MIN_FPS 1.0

#ifdef DEBUG
#define DBG_PRINT(...) g_print(__VA_ARGS__)
#else
#define DBG_PRINT(...) ((void)(0))
#endif

/* For XOverlay */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* GST own includes */
#include <gst/gst.h>
#include <gst/video/gstvideosink.h>
#include <dspvideo.h>
#include <gst/base/gstadapter.h>

G_BEGIN_DECLS


#define GST_TYPE_DSPMPEG4SINK          (gst_dspmpeg4sink_get_type())
#define GST_DSPMPEG4SINK(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPMPEG4SINK,GstDSPMPEG4Sink))
#define GST_DSPMPEG4SINK_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPMPEG4SINK,GstDSPMPEG4SinkClass))
#define GST_IS_DSPMPEG4SINK(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPMPEG4SINK))
#define GST_IS_DSPMPEG4SINK_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPMPEG4SINK))


typedef struct _GstDSPMPEG4Sink GstDSPMPEG4Sink;
typedef struct _GstDSPMPEG4SinkClass GstDSPMPEG4SinkClass;

struct _GstDSPMPEG4Sink {
  GstVideoSink videosink;
  GstPad        *sinkpad;
  GstDSPVideo   *video;
  GQueue        *fbf_queue;

  guint          write_size;  // Size of the data to be written (in bytes)
  guint8         *mmap_buf_addr;

  gboolean       discont_sent;
  gboolean       paused;
  gboolean       eos;
  gboolean       par_info_handled;

  GstClockTime   base_time;
  GstClockTime   prev_timestamp;

  gint            max;

  // For testing and measurements
#ifdef DEBUG
  int  p_ctr;
  int  d_count;
  int fd;
  gboolean seek;
#endif

};

struct _GstDSPMPEG4SinkClass {
  GstVideoSinkClass parent_class;
};

GType gst_dspmpeg4sink_get_type(void);
gboolean gst_dspmpeg4sink_factory_init (GstElementFactory *factory);

G_END_DECLS

#endif /* __GST_DSPMPEG4SINK_H__ */
