/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPMP3SINK_H__
#define __GST_DSPMP3SINK_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>
#include <gst/base/gstadapter.h>

#include <dspaudio.h>
#include <dsp/interface_common.h>
#include <dsp/audio_dsptask.h>
#include <dsp/mp3_dsptask.h>


G_BEGIN_DECLS

#define GST_TYPE_DSPMP3SINK          (gst_dspmp3sink_get_type())
#define GST_DSPMP3SINK(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPMP3SINK,GstDSPMP3Sink))
#define GST_DSPMP3SINK_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPMP3SINK,GstDSPMP3SinkClass))
#define GST_IS_DSPMP3SINK(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPMP3SINK))
#define GST_IS_DSPMP3SINK_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPMP3SINK))

enum
{
  DSPMP3_SIGNAL_STREAMID,
  DSPMP3_SIGNAL_LAST
};

typedef struct _GstDSPMP3Sink GstDSPMP3Sink;
typedef struct _GstDSPMP3SinkClass GstDSPMP3SinkClass;
typedef struct _MP3Frame MP3Frame;
typedef struct _XINGTag XINGTag;

struct _MP3Frame
{
  guint          sample_rate_hz;
  guint          channels;
  guint          layer;
  guint          mode;
  guint          bitrate;
  guint          granules;
  guint          lsf;
  guint          pad;
  gdouble        tpf;
};

struct _XINGTag
{
  guint32        xframes;
  guint32        xbytes;
  unsigned char  toc[100];
};

struct _GstDSPMP3Sink {
  GstBaseSink   sink;
  GstPad        *sinkpad;
  GstDSPAudio   *audio;
  GstAdapter    *adapter;
  MP3Frame      frame;
  XINGTag       xingtag;

  // stream characteristics
  gint           sample_rate;
  guint64        total_bytes;
  guint64        total_frames;
  guint64        frame_count;
  guint64        bitrate_sum;
  guint          avg_bitrate;
  guint          prev_bitrate;
  guint          vbr_counter;
  gboolean       paused;
  gboolean       vbr;
  gboolean       sync;

  // Seeking-related
  guint64        time_offset;
  guint          curr_fc;
  guint32        frame_seek_base;
  int            mmap_ptr;
  MP3_DATA_WRITE outbuf;
};


struct _GstDSPMP3SinkClass {
  GstBaseSinkClass parent_class;

  void (*stream_id) (GstDSPMP3Sink *sink, gint id);
};

GType gst_dspmp3sink_get_type(void);

G_END_DECLS

#endif /* __GST_DSPMP3SINK_H__ */
