/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <gst/gst.h>
#include "gstdspilbcsink.h"
#include "gstdspilbcsrc.h"

static gboolean
plugin_init (GstPlugin * plugin)
{
  if (!gst_element_register (plugin, "dspilbcsink", GST_RANK_PRIMARY,
        gst_dspilbcsink_get_type()))
    return FALSE;

  if (!gst_element_register (plugin, "dspilbcsrc", GST_RANK_PRIMARY,
        gst_dspilbcsrc_get_type()))
    return FALSE;

  return TRUE;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
                   GST_VERSION_MINOR,
                   "dspilbc",
                   "DSP ILBC audio I/O elements",
                   plugin_init,
                   VERSION,
                   "LGPL",
                   "dspaudio",
                   "Nokia Corporation");
