/*
 * Farsight Voice+Video library
 *  Copyright 2006 Collabora Ltd, 
 *  Copyright 2006 Nokia Corporation
 *   @author: Philippe Khalaf <philippe.khalaf@collabora.co.uk>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>

#include <talk/p2p/base/socketmanager.h>

#include "jingle_c.h"

using namespace cricket;

class SocketClient: public sigslot::has_slots<>
{
    public:
        SocketClient(SocketAddress *stun_addr,
                SocketAddress *turn_addr);
        virtual ~SocketClient();

        void SocketClient::CreateSocket(const std::string &name);

        void SetCandidatesReadyCb(candidates_ready_cb_type cb, gpointer data)
            { candidates_ready_cb = cb; candidates_ready_cb_data = data; };

        void SetStateCb(socket_state_change_cb_type cb, gpointer data)
            { state_cb = cb; socket_state_change_cb_data = data; };

        void SetNetworkErrorCb(empty_cb_type cb, gpointer data)
            { network_error_cb = cb; empty_cb_data = data; };

        void SetSocketReadCb(socket_read_cb_type cb, gpointer data)
            { socket_read_cb = cb; socket_read_cb_data = data; };

        SocketManager *getSocketManager() 
            { return socket_manager; };

        P2PSocket *getSocket()
            { return socket; };

    private:
        void OnRequestSignaling();
        void OnCandidatesReady(const std::vector<Candidate>& candidates);
        void OnNetworkError();
        void OnSocketState(P2PSocket *socket, P2PSocket::State state);
        void OnSocketRead(P2PSocket *socket, const char *data, size_t len);

        SocketManager *socket_manager;
        // We only create 1 socket per SocketClient (for now at least)
        P2PSocket *socket;


        int native_candidate_inc;

        /* callbacks */
        candidates_ready_cb_type candidates_ready_cb;
        socket_state_change_cb_type state_cb;
        empty_cb_type network_error_cb;
        socket_read_cb_type socket_read_cb;

        // the user defined data for the callbacks
        gpointer candidates_ready_cb_data;
        gpointer socket_state_change_cb_data;
        gpointer empty_cb_data;
        gpointer socket_read_cb_data;
};
