
import os
from utils import get_addrs
import sys
import ConfigParser

CURR_DIR = os.environ["PWD"]
MSGS_DIR = ""
if ( os.path.exists( os.environ["top_srcdir"]+"/tests/regression/stress/messages/" ) ):
    MSGS_DIR = os.environ["top_srcdir"]+"/tests/regression/stress/messages/"
    #print "MSGS_DIR (to_srcdir) = %s\n" % MSGS_DIR
else:
    if ( CURR_DIR.find('stress') == -1 ):
        MSGS_DIR = os.environ["PWD"]+"/stress/messages/"
        #print "MSGS_DIR = %s\n" % MSGS_DIR
    elif (os.path.exists(os.environ["PWD"]+"/messages/")):
        MSGS_DIR = os.environ["PWD"]+"/messages/"
        #print "MSGS_DIR = %s\n" % MSGS_DIR    

#NOTIFY message file name
SOAP_ACTION_MSG_FILENAME="soap_action_request.msg"
#NOTIFY message configuration parameters file name
SOAP_ACTION_PARAMS_FILENAME="soap_action_request.params"

class SOAPActionMessage:
    def __init__(self, fileNameParams = ""):
        """Sets default values """        
        if fileNameParams != "":
            self.loadSOAPActionMessageParams(fileNameParams);
        else:
            self.host = '10.1.1.9:38400'
            self.action_control = '/upnp/control/WANCommonIFC1'
            self.service_schema = 'urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1'
            self.action_name = 'GetTotalBytesReceived'

    def get_local_addr(self):
        addrs = get_addrs()
        addrs.remove('127.0.0.1')
        return addrs[0]
    
    def loadSOAPActionMessageParams(self, fileNameParams):
        """Load data from the SOAP Action message from a file."""
        config = ConfigParser.ConfigParser()
        if os.path.exists(MSGS_DIR+fileNameParams):
            config.read(MSGS_DIR+fileNameParams)
            try:
                host = config.get("SOAP Action Params", "host")
                action_control = config.get("SOAP Action Params", "action_control")
                service_schema = config.get("SOAP Action Params", "service_schema")
                action_name = config.get("SOAP Action Params", "action_name")
            except:
                raise "ConfigError", "Problems on configuration file (%s) " % fileNameParams
            else:
                self.host = host
                self.action_control = action_control
                self.service_schema = service_schema
                self.action_name = action_name
        else:
            print "Specified file doesn't exists! Creating file %s" % (MSGS_DIR+fileNameParams)
            self.create()

    def create(self):
        self.save()
    
    def save(self):
        """Store data from the SOAP Action message in a file."""
        config = ConfigParser.ConfigParser()
        config.add_section("SOAP Action Params")
        config.set("SOAP Action Params", "host", self.host)
        config.set("SOAP Action Params", "action_control", self.action_control)
        config.set("SOAP Action Params", "service_schema", self.service_schema)
        config.set("SOAP Action Params", "action_name", self.action_name)
        file = open(MSGS_DIR+self.paramsFilename, "w")
        config.write(file)
        file.close()
    
    def get_host(self):
        return self.host
    
    def get_action_control(self):
        return self.action_control

    def get_service_schema(self):
        return self.service_schema
    
    def get_action_name(self):
        return self.action_name
    
class SOAPActionMessageSession:
    def __init__(self, msgFilename = SOAP_ACTION_MSG_FILENAME, 
                 paramsFilename = SOAP_ACTION_PARAMS_FILENAME):
        self.msgFilename = msgFilename
        self.paramsFilename = paramsFilename
        self.soapMsg = SOAPActionMessage(self.paramsFilename)

    def getMsgContentFromFile(self, filename):
        #print "Opening message filename = %s\n" % (MSGS_DIR+filename)
        fileContent = []
        file_cnt = ""
        if os.path.exists(MSGS_DIR+filename):
            f = open(MSGS_DIR+filename, 'r+')
            file_cnt = f.read()
            fileContent = file_cnt.splitlines(False)
            #print "File content = ", fileContent
        file_cnt = "\r\n".join(fileContent)
        file_cnt += "\r\n\r\n"
        #print "Parsed file content = ", file_cnt
        return file_cnt

    def createSOAPActionMessage(self, host = None, fileMsg = SOAP_ACTION_MSG_FILENAME, 
                                 fileMsgParams = SOAP_ACTION_PARAMS_FILENAME):
        """Creating the SOAP Action message."""
        self.msgFilename = fileMsg
        self.paramsFilename = fileMsgParams
        msgSOAPAction = self.getMsgContentFromFile(self.msgFilename)
        # put the SSDP alive message parameters settled in the "params" file
        self.soapMsg = SOAPActionMessage(self.paramsFilename)
        if ( host == None ):
            host = self.soapMsg.host
        content_length = 297
        #print "Created soapMsg from file: %s\n" % self.soapMsg.show()
        soap_msg_final = (msgSOAPAction % (host, self.soapMsg.action_control, self.soapMsg.service_schema, 
                                           self.soapMsg.action_name, content_length, self.soapMsg.action_name, 
                                           self.soapMsg.service_schema))
        #print "\nMessage that will be sent = %s\n" % notify_msg_final
        return soap_msg_final
        
        