/* Provides a control point. When a device is added, it probes the
   device for all available information*/

#include <cybergarage/upnp/cupnp.h>
#include <stdlib.h>
#include <stdio.h>
#include "common.h"

CgUpnpControlPoint *ctrl;

void SSDPNotifyListener(CgUpnpSSDPPacket *ssdpPkt)
{
  if (cg_upnp_ssdp_packet_isalive(ssdpPkt) == TRUE) {
    CgUpnpDevice *dev;
    for (dev = cg_upnp_controlpoint_getdevices(ctrl);
	 dev != NULL;
	 dev = cg_upnp_device_next(dev)) {
      int timeout = 100;
      cg_upnp_controlpoint_subscribeall(ctrl, dev, timeout);

      char *deviceType = cg_upnp_device_getdevicetype(dev);
      printf("deviceType = %s\n", deviceType);

      CgUpnpDevice *d = cg_upnp_controlpoint_getdevicebytype(ctrl, deviceType);
      printf("%d\n", d == dev);

      d = cg_upnp_controlpoint_getdevicebyexacttype(ctrl, deviceType);
      printf("%d\n", d == dev);

      char *identifier = cg_upnp_devicetype_getidentifier(deviceType);
      printf("identifier = %s\n", identifier);

      char *urn        = cg_upnp_devicetype_geturn(deviceType);
      printf("urn = %s\n", urn);

      char *device     = cg_upnp_devicetype_getdevice(deviceType);
      printf("device = %s\n", device);

      char *type       = cg_upnp_devicetype_gettype(deviceType);
      printf("type = %s\n", type);

      char *schema     = cg_upnp_devicetype_getschematype(deviceType);
      printf("schema = %s\n", schema);

      char *version    = cg_upnp_devicetype_getversion(deviceType);
      printf("version = %s\n", version);

      cg_upnp_device_getservicebytype(dev, "abc");
      CgUpnpAction *action = cg_upnp_device_getactionbyname(dev, "Say");
      if (action != NULL) {
	CgUpnpArgument *arg = cg_upnp_action_getargumentbyname(action, "What");
	if (arg != NULL) {
	  cg_upnp_argument_setvalue(arg, "Hello World\n");
	  cg_upnp_action_post(action);
	  cg_upnp_argument_setvalue(arg, "Good Bye");
	  cg_upnp_action_post(action);
	}
      }
      CgUpnpStateVariable *var = cg_upnp_device_getstatevariablebyname(dev, "Test");
      if (var)
	cg_upnp_statevariable_post(var);

      CgUpnpService *service;
      for (service = cg_upnp_device_getservices(dev);
	   service != NULL;
	   service = cg_upnp_service_next(service)) {

	cg_upnp_service_getactions(service);

	char *serviceType = cg_upnp_service_getservicetype(service);
	printf("serviceType = %s\n", serviceType);

	char *identifier = cg_upnp_servicetype_getidentifier(serviceType);
	printf("identifier = %s\n", identifier);

	char *urn = cg_upnp_servicetype_geturn(serviceType);
	printf("urn = %s\n", urn);

	char *service = cg_upnp_servicetype_getservice(serviceType);
	printf("service = %s\n", service);

	char *type = cg_upnp_servicetype_gettype(serviceType);
	printf("type = %s\n", type);

	char *schema = cg_upnp_servicetype_getschematype(serviceType);
	printf("schema = %s\n", schema);

	char *version = cg_upnp_servicetype_getversion(serviceType);
	printf("version = %s\n", version);
      }
    }
  }
}

void deviceListener(char* udn, CgUpnpDeviceStatus status)
{
}

void EventListener(CgUpnpProperty *prop)
{
}

int main() {
  ctrl = cg_upnp_controlpoint_new();
  cg_upnp_controlpoint_setssdplistener(ctrl, SSDPNotifyListener);
  cg_upnp_controlpoint_setdevicelistener(ctrl, deviceListener);
  cg_upnp_controlpoint_seteventlistener(ctrl, EventListener);
  cg_upnp_controlpoint_seteventlistener(ctrl, NULL);
  cg_upnp_controlpoint_start(ctrl);

  cg_upnp_controlpoint_ipchanged(ctrl);

  printf(SYNC_STRING);
  fflush(NULL);
  getchar();

  CgUpnpDevice *dev;
  for (dev = cg_upnp_controlpoint_getdevices(ctrl);
       dev != NULL;
       dev = cg_upnp_device_next(dev)) {
    cg_upnp_controlpoint_resubscribeall(ctrl, dev, 100);
    cg_upnp_controlpoint_unsubscribeall(ctrl, dev);
  }

  cg_upnp_controlpoint_stop(ctrl);
  cg_upnp_controlpoint_delete(ctrl);

  return 0;
}
