/************************************************************
*
*	CyberLink for C
*
*	Copyright (C) Satoshi Konno 2005
*
*	File: clock_device.c
*
*	Revision:
*       05/11/05
*               - first release.
*
*	10/31/05
*		- Removed :schemas: from clock service description
*
*	11-Jan-06 Heikki Junnila
*		- Renamed *_getservicebyname's to *_getservicebyexacttype
*
************************************************************/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "clock_device.h"
#include "clock.h"

#include <string.h>

/****************************************
* Descriptions
****************************************/

char *CLOCK_SERVICE_DESCRIPTION =
"<?xml version=\"1.0\"?>\n"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\" >\n"
" 	<specVersion>\n"
" 		<major>1</major>\n"
" 		<minor>0</minor>\n"
" 	</specVersion>\n"
" 	<actionList>\n"
" 		<action>\n"
" 			<name>SetTime</name>\n"
" 			<argumentList>\n"
" 				<argument>\n"
" 					<name>NewTime</name>\n"
" 					<relatedStateVariable>Time</relatedStateVariable>\n"
" 					<direction>in</direction>\n"
" 				</argument>\n"
" 				<argument>\n"
" 					<name>Result</name>\n"
" 					<relatedStateVariable>Result</relatedStateVariable>\n"
" 					<direction>out</direction>\n"
" 				</argument>\n"
" 			</argumentList>\n"
" 		</action>\n"
" 		<action>\n"
" 			<name>GetTime</name>\n"
" 			<argumentList>\n"
" 				<argument>\n"
" 					<name>CurrentTime</name>\n"
" 					<relatedStateVariable>Time</relatedStateVariable>\n"
" 					<direction>out</direction>\n"
" 				</argument>\n"
" 			</argumentList>\n"
" 		</action>\n"
" 		<action>\n"
" 			<name>SomeActionWhichGeneratesAnError</name>\n"
" 			<argumentList>\n"
" 				<argument>\n"
" 					<name>CurrentTime</name>\n"
" 					<relatedStateVariable>Time</relatedStateVariable>\n"
" 					<direction>out</direction>\n"
" 				</argument>\n"
" 			</argumentList>\n"
" 		</action>\n"
" 	</actionList>\n"
" 	<serviceStateTable>\n"
" 		<stateVariable sendEvents=\"yes\">\n"
" 			<name>Time</name>\n"
" 			<dataType>string</dataType>\n"
" 		</stateVariable>\n"
" 		<stateVariable sendEvents=\"no\">\n"
" 			<name>Result</name>\n"
" 			<dataType>string</dataType>\n"
" 		</stateVariable>\n"
" 	</serviceStateTable>\n"
"</scpd>\n";

char *EMB_SRV_DESC1 =
"<?xml version=\"1.0\"?>\n"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\" >\n"
" 	<specVersion>\n"
" 		<major>1</major>\n"
" 		<minor>0</minor>\n"
" 	</specVersion>\n"
" 	<actionList>\n"
" 		<action>\n"
" 			<name>EmbSrv1Action</name>\n"
" 			<argumentList>\n"
" 				<argument>\n"
" 					<name>EmbSrv1VariableValue</name>\n"
" 					<relatedStateVariable>EmbSrv1StateVariable</relatedStateVariable>\n"
" 					<direction>out</direction>\n"
" 				</argument>\n"
" 			</argumentList>\n"
" 		</action>\n"
" 	</actionList>\n"
" 	<serviceStateTable>\n"
" 		<stateVariable sendEvents=\"yes\">\n"
" 			<name>EmbSrv1StateVariable</name>\n"
" 			<dataType>string</dataType>\n"
" 		</stateVariable>\n"
" 	</serviceStateTable>\n"
"</scpd>\n";

char *EMB_SRV_DESC2 =
"<?xml version=\"1.0\"?>\n"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\" >\n"
" 	<specVersion>\n"
" 		<major>1</major>\n"
" 		<minor>0</minor>\n"
" 	</specVersion>\n"
" 	<actionList>\n"
" 		<action>\n"
" 			<name>EmbSrv2Action</name>\n"
" 			<argumentList>\n"
" 				<argument>\n"
" 					<name>EmbSrv2VariableValue</name>\n"
" 					<relatedStateVariable>EmbSrv2StateVariable</relatedStateVariable>\n"
" 					<direction>out</direction>\n"
" 				</argument>\n"
" 			</argumentList>\n"
" 		</action>\n"
" 	</actionList>\n"
" 	<serviceStateTable>\n"
" 		<stateVariable sendEvents=\"yes\">\n"
" 			<name>EmbSrv2StateVariable</name>\n"
" 			<dataType>string</dataType>\n"
" 		</stateVariable>\n"
" 	</serviceStateTable>\n"
"</scpd>\n";

char *EMB_SRV_DESC3 =
"<?xml version=\"1.0\"?>\n"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\" >\n"
" 	<specVersion>\n"
" 		<major>1</major>\n"
" 		<minor>0</minor>\n"
" 	</specVersion>\n"
" 	<actionList>\n"
" 		<action>\n"
" 			<name>EmbSrv3Action</name>\n"
" 			<argumentList>\n"
" 				<argument>\n"
" 					<name>EmbSrv3VariableValue</name>\n"
" 					<relatedStateVariable>EmbSrv3StateVariable</relatedStateVariable>\n"
" 					<direction>out</direction>\n"
" 				</argument>\n"
" 			</argumentList>\n"
" 		</action>\n"
" 	</actionList>\n"
" 	<serviceStateTable>\n"
" 		<stateVariable sendEvents=\"yes\">\n"
" 			<name>EmbSrv3StateVariable</name>\n"
" 			<dataType>string</dataType>\n"
" 		</stateVariable>\n"
" 	</serviceStateTable>\n"
"</scpd>\n";

/****************************************
* upnp_clock_actionreceived
****************************************/

BOOL upnp_clock_actionreceived(CgUpnpAction *action)
{
	CgSysTime currTime;
	char *actionName;
	CgUpnpArgument *currTimeArg;
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	CgUpnpArgument *newTimeArg, *resultArg;

	currTime = cg_getcurrentsystemtime();
	
	actionName = cg_upnp_action_getname(action);
	if (strcmp("GetTime", actionName) == 0) {
		GetSystemTimeString(currTime, sysTimeStr);
		currTimeArg = cg_upnp_action_getargumentbyname(action, "CurrentTime");
		cg_upnp_argument_setvalue(currTimeArg, sysTimeStr);
		return TRUE;
	}
	if (strcmp("SomeActionWhichGeneratesAnError", actionName) == 0) {
		cg_upnp_action_setstatuscode(action, 854);
		cg_upnp_action_setstatusdescription(action, "A non-standard error");
		return FALSE;
	}
	if (strcmp(actionName, "SetTime") == 0) {
		newTimeArg = cg_upnp_action_getargumentbyname(action, "NewTime");
		resultArg = cg_upnp_action_getargumentbyname(action, "Result");
		cg_upnp_argument_setvalue(resultArg, "Not implemented");
		return TRUE;
	}
	if (strcmp("EmbSrv1Action", actionName) == 0) {
		currTimeArg = cg_upnp_action_getargumentbyname(action, "EmbSrv1VariableValue");
		cg_upnp_argument_setvalue(currTimeArg, "TODO: EmbSrv1StateVariable value");
		return TRUE;
	}
	if (strcmp("EmbSrv2Action", actionName) == 0) {
		currTimeArg = cg_upnp_action_getargumentbyname(action, "EmbSrv2VariableValue");
		cg_upnp_argument_setvalue(currTimeArg, "TODO: EmbSrv2StateVariable value");
		return TRUE;
	}
	if (strcmp("EmbSrv3Action", actionName) == 0) {
		currTimeArg = cg_upnp_action_getargumentbyname(action, "EmbSrv3VariableValue");
		cg_upnp_argument_setvalue(currTimeArg, "TODO: EmbSrv3StateVariable value");
		return TRUE;
	}
	return FALSE;
}

/****************************************
* upnp_clock_queryreceived
****************************************/

BOOL upnp_clock_queryreceived(CgUpnpStateVariable *statVar)
{
	char *varName;
	CgSysTime currTime;
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	
	varName = cg_upnp_statevariable_getname(statVar);
	if (strcmp("Time", varName) == 0) {
		currTime = cg_getcurrentsystemtime();
		GetSystemTimeString(currTime, sysTimeStr);
		cg_upnp_statevariable_setvalue(statVar, sysTimeStr);
		return TRUE;
	}
	else if ( !strcmp("EmbSrv1StateVariable", varName) )
	{
		cg_upnp_statevariable_setvalue(statVar, "TODO: EmbSrv1StateVariable value");
		return TRUE;
	}
	else if ( !strcmp("EmbSrv2StateVariable", varName) )
	{
		cg_upnp_statevariable_setvalue(statVar, "TODO: EmbSrv2StateVariable value");
		return TRUE;
	}
	else if ( !strcmp("EmbSrv3StateVariable", varName) )
	{
		cg_upnp_statevariable_setvalue(statVar, "TODO: EmbSrv3StateVariable value");
		return TRUE;
	}
	
	return FALSE;
}

/****************************************
* upnp_clock_device_httprequestrecieved
****************************************/

void upnp_clock_device_httprequestrecieved(CgHttpRequest *httpReq)
{
	CgSysTime currTime;
	CgUpnpDevice *dev;
	char *uri;
	char content[2048];
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	char serverName[CG_UPNP_SEVERNAME_MAXLEN];
	CgHttpResponse *httpRes;
	BOOL postRet;
	
	dev = (CgUpnpDevice *)cg_http_request_getuserdata(httpReq);

	uri = cg_http_request_geturi(httpReq);
	if (strcmp(uri, "/presentation") != 0) {
		cg_upnp_device_httprequestrecieved(httpReq);
		return;
	}

	currTime = cg_getcurrentsystemtime();

#if defined(HAVE_SNPRINTF)
	snprintf(content, sizeof(content),
#else
	sprintf(content,
#endif
		"<HTML>"
		"<HEAD>"
		"<TITLE>UPnP Clock Sample</TITLE>"
		"</HEAD>"
		"<META HTTP-EQUIV=\"Refresh\" CONTENT=\"1; URL=/presentation\">"
		"<BODY><CENTER>"
		"<H1>UPnP Clock Sample</H1>"
		"<TABLE border=\"0\" cellpadding=\"0\" cellspacing=\"0\">"
		"<TR>"
		"<TD style=\"width: 50px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"width: 50px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"<TR>"
		"<TD style=\"height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"height: 50px; background-color: rgb(221, 236, 245);\" align=\"center\"><H1>"
		"%s"
		"</H1></TD>"
		"<TD style=\"height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"<TR>"
		"<TD style=\"height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"height: 50px; background-color: rgb(221, 236, 245);\" align=\"center\"><H3>"
		"Server : %s"
		"</H3></TD>"
		"<TD style=\"height: 30px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"<TR>"
		"<TD style=\"width: 30px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"width: 30px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"</TABLE>"
		"<CENTER></BODY>"
		"</HTML>",
		GetSystemTimeString(currTime, sysTimeStr),
		cg_upnp_getservername(serverName, sizeof(serverName)));

	httpRes = cg_http_response_new();
	cg_http_response_setstatuscode(httpRes, CG_HTTP_STATUS_OK);
	cg_http_response_setcontent(httpRes, content);
	cg_http_response_setcontenttype(httpRes, "text/html");
	cg_http_response_setcontentlength(httpRes, strlen(content));
	postRet = cg_http_request_postresponse(httpReq, httpRes);
	cg_http_response_delete(httpRes);
}

/****************************************
* upnp_clock_device_new
****************************************/

CgUpnpDevice *upnp_clock_device_new()
{
	CgUpnpDevice *clockDev;
	CgUpnpService *timeService;
	CgUpnpService *embeddedService1;
	CgUpnpService *embeddedService2;
	CgUpnpService *embeddedService3;
	 
	clockDev = cg_upnp_device_new();
	if ( cg_upnp_device_loaddescriptionfile(clockDev, "description.xml") == FALSE ) {
                printf( "cg_upnp_device_loaddescriptionfile() failed\n" );
		cg_upnp_device_delete(clockDev);
		return NULL;
	}

	timeService = cg_upnp_device_getservicebyexacttype(clockDev, "urn:schemas-upnp-org:service:timer:1");
	if (timeService == NULL) {
                printf( "cg_upnp_device_getservicebyname(clockDev, urn:schemas-upnp-org:service:timer:1) failed\n" );
		cg_upnp_device_delete(clockDev);
		return NULL;
	}
	
	if (cg_upnp_service_parsedescription(timeService, CLOCK_SERVICE_DESCRIPTION, strlen(CLOCK_SERVICE_DESCRIPTION)) == FALSE) {
		cg_upnp_device_delete(clockDev);
		return NULL;
	}

	embeddedService1 = cg_upnp_device_getservicebyexacttype(clockDev, "urn:schemas-upnp-org:service:embeddedtimer1:1");
	if (embeddedService1 == NULL) {
                printf( "cg_upnp_device_getservicebyname(clockDev, urn:schemas-upnp-org:service:embeddedtimer1:1) failed\n" );
                cg_upnp_device_delete(clockDev);
		return NULL;
	}
	
	if (cg_upnp_service_parsedescription(embeddedService1, EMB_SRV_DESC1, strlen(EMB_SRV_DESC1)) == FALSE) {
		cg_upnp_device_delete(clockDev);
		return NULL;
	}

	embeddedService2 = cg_upnp_device_getservicebyexacttype(clockDev, "urn:schemas-upnp-org:service:embeddedtimer2:1");
	if (embeddedService2 == NULL) {
                printf( "cg_upnp_device_getservicebyname(clockDev, urn:schemas-upnp-org:service:embeddedtimer2:1) failed\n" );
		cg_upnp_device_delete(clockDev);
		return NULL;
	}
	
	if (cg_upnp_service_parsedescription(embeddedService2, EMB_SRV_DESC2, strlen(EMB_SRV_DESC2)) == FALSE) {
		cg_upnp_device_delete(clockDev);
		return NULL;
	}

	embeddedService3 = cg_upnp_device_getservicebyexacttype(clockDev, "urn:schemas-upnp-org:service:embeddedtimer3:1");
	if (embeddedService3 == NULL) {
                printf( "cg_upnp_device_getservicebyname(clockDev, urn:schemas-upnp-org:service:embeddedtimer3:1) failed\n" );
		cg_upnp_device_delete(clockDev);
		return NULL;
	}
	
	if (cg_upnp_service_parsedescription(embeddedService3, EMB_SRV_DESC3, strlen(EMB_SRV_DESC3)) == FALSE) {
		cg_upnp_device_delete(clockDev);
		return NULL;
	}

	cg_upnp_device_setactionlistener(clockDev, upnp_clock_actionreceived);
	cg_upnp_device_setquerylistener(clockDev, upnp_clock_queryreceived);
	cg_upnp_device_sethttplistener(clockDev, upnp_clock_device_httprequestrecieved);

	return clockDev;
}

/****************************************
* upnp_clock_device_update
****************************************/

void upnp_clock_device_update(CgUpnpDevice *clockDev)
{
	CgSysTime currTime;
	CgUpnpService *timeService;
	CgUpnpStateVariable *timeState;
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	
	timeService = cg_upnp_device_getservicebyexacttype(clockDev, "urn:schemas-upnp-org:service:timer:1");
	if (timeService == NULL)
		return;

	timeState = cg_upnp_service_getstatevariablebyname(timeService, "Time");
	if (timeState == NULL)
		return;
	
	currTime = cg_getcurrentsystemtime();
	GetSystemTimeString(currTime, sysTimeStr);
	cg_upnp_statevariable_setvalue(timeState, sysTimeStr);
	
	printf("%s\n", sysTimeStr);
}

