/**
 * @file libgalago/galago-private.h Private declarations
 * @ingroup Utility
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_PRIVATE_H_
#define _GALAGO_PRIVATE_H_

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) dgettext(GETTEXT_PACKAGE, String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif
#else /* NLS is disabled */
# define _(String) (String)
# define N_(String) (String)
# define textdomain(String) (String)
# define gettext(String) (String)
# define dgettext(Domain,String) (String)
# define dcgettext(Domain,String,Type) (String)
# define bindtextdomain(Domain,Directory) (Domain)
# define bind_textdomain_codeset(Domain,Codeset) (Codeset)
#endif /* ENABLE_NLS */

#include <libgalago/galago-account.h>
#include <libgalago/galago-service.h>
#include <libgalago/galago-person.h>

#define GALAGO_ME_ID "_galago_me_"

GalagoAccount *_galago_account_new(GalagoService *service,
								   GalagoPerson *person,
								   const char *username,
								   const char *obj_path);

void _galago_account_presence_created(GalagoAccount *account,
									  GalagoPresence *presence);
void _galago_account_presence_deleted(GalagoAccount *account);
void _galago_dbus_account_create_presence(GalagoAccount *account,
										  GalagoPresence *presence);

/**
 * Sets the account's presence.
 *
 * @internal This is used internally.
 *
 * @param account  The account.
 * @param presence The presence to set.
 */
void _galago_account_set_presence(GalagoAccount *account,
								  GalagoPresence *presence);

/**
 * Adds an account to a service.
 *
 * @internal This is used internally.
 *
 * @param service The service.
 * @param account The account to add.
 */
void _galago_service_add_account(GalagoService *service,
								 GalagoAccount *account);

/**
 * Removes an account from a service.
 *
 * @internal This is used internally.
 *
 * @param service The service.
 * @param account The account to remove.
 */
void _galago_service_remove_account(GalagoService *service,
									GalagoAccount *account);

/**
 * Adds an account to a person.
 *
 * @internal This is used internally.
 *
 * @param person  The person.
 * @param account The account to add.
 */
void _galago_person_add_account(GalagoPerson *person, GalagoAccount *account);

/**
 * Removes an account from a person.
 *
 * @internal This is used internally.
 *
 * @param person  The person.
 * @param account The account to remove.
 */
void _galago_person_remove_account(GalagoPerson *person,
								   GalagoAccount *account);

void _galago_person_set_id(GalagoPerson *person, const char *id);
void _galago_person_set_session_id(GalagoPerson *person,
								   const char *session_id);

GalagoPresence *_galago_presence_new(GalagoAccount *account,
									 const char *obj_path);

#endif /* _GALAGO_PRIVATE_H_ */
