/*
 * Copyright © 2006 Nokia Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the authors not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The authors make no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <X11/X.h>
#include <X11/Xlib.h>

#include "Xsp.h"

#include <stdio.h>

int main (int argc, char **argv)
{
	Display *dpy;
	int event_base, error_base;
	int major, minor;

	dpy = XOpenDisplay(NULL);
	if (!XSPQueryExtension(dpy, &event_base, &error_base, &major, &minor))
	{
		fprintf(stderr, "XSP extension not available\n");
		XCloseDisplay(dpy);
		return 1;
	}

	printf("XSP extension found:\n");
	printf("  event_base: %d\n", event_base);
	printf("  error_base: %d\n", error_base);
	printf("       major: %d\n", major);
	printf("       minor: %d\n", minor);
	
	if (!XSPRegisterDSPArea(dpy, DefaultScreen(dpy), 0, 0, 800, 480)) {
		fprintf(stderr, "XSPRegisterDSPArea failed\n");
	}

	if (!XSPCancelDSPArea(dpy, DefaultScreen(dpy))) {
		fprintf(stderr, "XSPCancelDSPArea failed\n");
	}
	XCloseDisplay(dpy);
	return 0;
}
