/**
  @file log.c

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <glib.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef USE_OSSOLOG
# include <osso-log.h>
#else
# include <syslog.h>
# define DLOG_OPEN(name) openlog(name, LOG_PID, LOG_DAEMON)
# define DLOG_INFO(fmt, args...) syslog(LOG_INFO, fmt, ## args)
# define DLOG_ERR(fmt, args...) syslog(LOG_ERR, fmt, ## args)
# define DLOG_CRIT(fmt, args...) syslog(LOG_CRIT, fmt, ## args)
# define DLOG_WARN(fmt, args...) syslog(LOG_WARNING, fmt, ## args)
# define DLOG_DEBUG(fmt, args...) syslog(LOG_CRIT, fmt, ## args)
#endif

#include "log.h"


static void app_info_log(const gchar *str) {
    DLOG_INFO("%s", str);
}

static void app_info_out(const gchar *str) {
    printf("%s\n", str);
}

static void app_error_log(const gchar *str) {
    DLOG_ERR("%s", str);
}

static void app_error_out(const gchar *str) {
    fprintf(stderr, "%s\n", str);
}

void open_log(const char *name, gboolean use_syslog) {
    if (use_syslog) {
        DLOG_OPEN(name);
        g_set_print_handler(app_info_log);
        g_set_printerr_handler(app_error_log);
    }
    else {
        g_set_print_handler(app_info_out);
        g_set_printerr_handler(app_error_out);
    }
}

