/**
  @file bttools-dbus.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BTTOOLS_DBUS_H_
#define _BTTOOLS_DBUS_H_

/* btpin defines */
#define PINAGENT_SERVICE                "org.bluez.PinAgent"
#define PINAGENT_INTERFACE              "org.bluez.PinAgent"
                                        
#define BTPIN_SERVICE                   "com.nokia.btpin"
#define BTPIN_INTERFACE                 "com.nokia.btpin"
#define BTPIN_PATH                      "/com/nokia/btpin"
                                        
#define BTPIN_REQ_REGISTER              "register"
#define BTPIN_REQ_UNREGISTER            "unregister"
                                        
#define BTPIN_ERROR                     BTPIN_SERVICE ".error."
#define BTPIN_ERROR_DUPLICATE           BTPIN_ERROR "duplicate"
#define BTPIN_ERROR_NOMATCH             BTPIN_ERROR "nomatch"
                                        
                                        
/* btname defines */                    
#define BTNAME_SERVICE                  "com.nokia.btname"
#define BTNAME_REQUEST_IF               "com.nokia.btname.request"
#define BTNAME_SIGNAL_IF                "com.nokia.btname.signal"
#define BTNAME_REQUEST_PATH             "/com/nokia/btname/request"
#define BTNAME_SIGNAL_PATH              "/com/nokia/btname/signal"
                                        
#define BTNAME_REQ_GET                  "get"
#define BTNAME_REQ_SET                  "set"
#define BTNAME_SIG_CHANGED              "changed"
                                        
#define BTNAME_ERROR                     BTNAME_SERVICE ".error."
#define BTNAME_ERROR_INVALID             BTNAME_ERROR "invalid"
#define BTNAME_ERROR_FAILED              BTNAME_ERROR "failed"
                                        
                                        
/* btpair defines */                    
#define BTPAIR_SERVICE                  "com.nokia.btpair"
#define BTPAIR_INTERFACE                "com.nokia.btpair"
#define BTPAIR_PATH                     "/com/nokia/btpair"
                                        
#define BTPAIR_REQ_PAIR_BDA             "pair_bda"
#define BTPAIR_REQ_PAIR_HANDLE          "pair_handle"
#define BTPAIR_REQ_REMOVE_PAIRING       "remove_pairing"

#define BTPAIR_ERROR                    BTPAIR_SERVICE ".error."
#define BTPAIR_ERROR_CONNECT_FAILED     BTPAIR_ERROR "connect_failed"
#define BTPAIR_ERROR_DISCONNECTED       BTPAIR_ERROR "disconnected"
#define BTPAIR_ERROR_TIMEOUT            BTPAIR_ERROR "timeout"
#define BTPAIR_ERROR_REFUSED            BTPAIR_ERROR "refused"
#define BTPAIR_ERROR_AUTH_FAILED        BTPAIR_ERROR "auth_failed"
#define BTPAIR_ERROR_TOO_FREQUENT       BTPAIR_ERROR "too_frequent"
#define BTPAIR_ERROR_RESOURCE_LIMIT     BTPAIR_ERROR "resource_limit"
#define BTPAIR_ERROR_CANCELED           BTPAIR_ERROR "canceled"
#define BTPAIR_ERROR_FAILED             BTPAIR_ERROR "failed"
#define BTPAIR_ERROR_IN_PROGRESS        BTPAIR_ERROR "in_progress"

#endif /* _BTTOOLS_DBUS_H_ */
