#!/bin/sh
# Copyright (C) 2004-2005 Nokia Corporation.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA


if [ $# -lt 3 ]; then
  echo "Usage: $0 {start|stop|restart} servicename cmd [params]"
  exit 1
fi

STOP=FALSE
START=FALSE

case "$1" in
start)  START=TRUE
        ;;
stop)   STOP=TRUE
        ;;
restart)
        STOP=TRUE
        START=TRUE
        ;;
*)      echo "Usage: $0 {start|stop|restart} servicename cmd [params]"
        exit 1
        ;;
esac

shift
SVC="$1"
shift
CMD=$1
BASENAME=`basename $CMD`
PIDFILE=$AF_PIDDIR/$BASENAME.pid
shift
PARAMS=$@

if [ $STOP = TRUE ]; then
  echo "Stopping $SVC"
  /sbin/start-stop-daemon --stop -p $PIDFILE -R TERM/1/KILL -q &
fi

if [ $START = TRUE ]; then
  echo "Starting $SVC"
  /sbin/start-stop-daemon --start -x $CMD -p $PIDFILE -o -m -q -- $PARAMS &
fi
