/*
 * This file is part of maemopad
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef CALLBACKS_H
#define CALLBACKS_H

#include <ui/interface.h>
#include <gtk/gtk.h>
#include <appdata.h>
#include <osso-helplib.h>

#define HELP_TOPIC_ID "Example_MaemoPad_Content"

/* edit-> cut/copy/paste */
void callback_edit_cut ( GtkAction * action, gpointer data );
void callback_edit_copy ( GtkAction * action, gpointer data );
void callback_edit_paste ( GtkAction * action, gpointer data );
/* file-> new/open/save */
void callback_file_new ( GtkAction * action, gpointer data );
void callback_file_open ( GtkAction * action, gpointer data );
void callback_file_save ( GtkAction * action, gpointer data );
void callback_file_saveas ( GtkAction * action, gpointer data );
/* font */
void callback_font ( GtkAction * action, gpointer data );
/* fullscreen */
void callback_fullscreen ( GtkAction * action, gpointer data );
/* help */
void callback_help ( GtkAction * action, gpointer data );

/* buffer modified */
void callback_buffer_modified ( GtkAction * action, gpointer data );

#endif
