/*
 * rtpgstcodecs.h - Headers for RTP gstreamer codec setting
 *
 * Farsight RTP/AVP/SAVP/AVPF Module
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT 
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_RTP_GST_CODECS_H__
#define __FARSIGHT_RTP_GST_CODECS_H__

#include <gst/gst.h>

#include "farsight-stream.h"
#include "farsight-codec.h"
#include "rtp.h"

G_BEGIN_DECLS

G_CONST_RETURN GList *load_codecs (FarsightMediaType media_type, 
                                   const GHashTable **list_codecs_internal);
void unload_codecs (FarsightMediaType media_type);
void sort_codecs (GList **list_codecs, 
                  FarsightCodecPreference codec_preference[], 
                  guint size);
GHashTable *create_pt_caps_hashtable (GList *codecs);

G_END_DECLS

#endif
