/*
 * rtp.h - Headers for RTP Plugin core
 *
 * Farsight RTP/AVP/SAVP/AVPF Module
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT 
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_RTP_H__
#define __FARSIGHT_RTP_H__

#include <gst/gst.h>

#include "farsight-codec.h"

G_BEGIN_DECLS

/* Forward Declaration */
typedef struct _FarsightRTPSession FarsightRTPSession;
typedef struct _FarsightRTPStream FarsightRTPStream;
typedef struct _CodecInternal CodecInternal;

struct _CodecInternal
{
  FarsightCodec *codec;
  GList *send_pipeline_factory;
  GList *receive_pipeline_factory;
  gboolean has_sink;
  gboolean has_src;
};

G_END_DECLS

#endif
