#include <stdio.h>
#include <glib.h>
#include <libosso.h>
#include <sys/un.h>
#include <sys/socket.h>
#include <gconf/gconf-client.h>
#include <shadowappd.h>

#include <signal.h>

sapp_d_data *main_context;

GMainLoop *mainloop;

void call_exit_function(void)
{
  g_main_loop_quit(mainloop);
}

void segmentation_fault(int signal)
{
#ifdef SAPPD_DEBUG
  _sd_debugprint("Segmentation Fault");
#endif

  exit(-1);
}

int main(int argc, char *argv[])
{
  FILE *pFile;

#ifdef SAPPD_DEBUG
  pFile = fopen("/root/.gamewrapper/wrapper.debug", "a");
  if(pFile) {
    fprintf(pFile, "executing wrapper\n");
    fclose(pFile);
  }
#endif

  if(argc < 2) {
    printf("usage: %s <filename>\n", argv[0]);
#ifdef SAPPD_DEBUG
    _sd_debugprint("illegal argumenting");
#endif
  }

#ifdef SAPPD_DEBUG
  _sd_debugprint("we are launched");
#endif

  g_type_init();
  gconf_init(argc, argv, NULL);

/*signal(SIGSEGV, segmentation_fault);*/

  mainloop = g_main_loop_new(NULL, FALSE);
  main_context = sappd_initialize(argv[1], NULL, mainloop);
  if(main_context == NULL) {
    printf("cannot init sappd: %d\n", sappd_error);
#ifdef SAPPD_DEBUG
    _sd_debugprint("cannot init sappd :'(");
#endif
    return -1;
  }

  sappd_init_sigchld(main_context);

  main_context->quit_callback = call_exit_function;

#ifdef SAPPD_DEBUG
  _sd_debugprint("wrapper up and running");
#endif

  g_main_loop_run(mainloop);

/*waitpid(main_context->child_pid, NULL, 0);*/

  sappd_deinitialize(main_context,
                     SAPPD_DEINIT_STATESAVE | SAPPD_DEINIT_REPORT |
                     (SAPPD_DEINIT_CRASHED*(sappd_crashed != 0)));

  return 0;
}
