/**
   X Colorkey eXtension

   Authors:
   Tapani Paelli <tapani.palli@nokia.com>
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "xck.h"

/**
   xckCreatePixmap - wrapped function.
   initializes colorkey datastructure
*/
PixmapPtr
xckCreatePixmap(ScreenPtr pScreen,
		int       width,
		int       height,
		int       depth)
{
  xckScrPriv(pScreen);
  PixmapPtr pPixmap;
  unwrap (pScrPriv, pScreen, CreatePixmap);
  pPixmap = (*pScreen->CreatePixmap) (pScreen,width,height,depth);
  wrap (pScrPriv, pScreen, CreatePixmap, xckCreatePixmap);

  /* initialize colorkey data structure */
  XCK_data p = xckGetPixPriv(pPixmap);
  /* not scanned yet */
  p->type = XCK_UNKNOWN;
  /* memory will be allocated at runtime */
  p->position_map = NULL;
  p->l_offset = 0;
  p->r_offset = 0;
  p->u_offset = 0;
  p->d_offset = 0;

  return pPixmap;
}

/**
   xckDestroyPixmap - wrapped function
*/
Bool
xckDestroyPixmap (PixmapPtr pPixmap)
{
  XCK_data priv = xckGetPixPriv(pPixmap);
  ScreenPtr   pScreen = pPixmap->drawable.pScreen;
  Bool result;
  xckScrPriv(pScreen);

  /**
  if (priv != NULL)
  {
    xfree(priv);
    pScreen->devPrivates[xckPixPrivateIndex].ptr = NULL;
  }
  */
  unwrap (pScrPriv, pScreen, DestroyPixmap);
  result = (*pScreen->DestroyPixmap) (pPixmap);
  wrap (pScrPriv, pScreen, DestroyPixmap, xckDestroyPixmap);
  return result;
}


/**
   At first blit, pixmap will be scanned to check if there is a way
   to optimize the blitting. function will save results to XCK_data
   structure hooked in pixmap devprivates

   stores 2 ints per scanline, 1st is the position and 2nd is bytecount to copy
   then we use memcpy to those values in blitting loop

   weakness of this is of course that we cannot have transparent holes in pixmap.
   we could have a RLE encoded list of scanlines for a COMPLEX pixmap (pixmap with holes).

   *** warning : this is very very critical part of the whole xck code ***

   @par pDrawable pixmap to scan

   latest change : 13.1, tp (bugfix)
*/
void
xckScanPixmap (DrawablePtr pDrawable, int ckey)
{
  unsigned int bpp, Xoff, Yoff;
  unsigned int height, width, x, y;

  int stride;
  FbBits *p = NULL;

  fbGetDrawable (pDrawable, p, stride, bpp, Xoff, Yoff);

  height = pDrawable->height;
  width = pDrawable->width*bpp;

  PixmapPtr pix = (PixmapPtr) LookupIDByType (pDrawable->id , RT_PIXMAP);
  XCK_data pdata = xckGetPixPriv(pix);

  pdata->position_map = xalloc (2 * (height * sizeof(int)));
  bzero(pdata->position_map, (2 * (height * sizeof(int))));

  unsigned int *pos_table = pdata->position_map;
  unsigned int totalbytes = width*height;

  if ((width&7)==0)
  {
      CARD16 *isrc = (CARD16*) p;
      CARD16 *srcp = (CARD16*) p;

      unsigned int sstride = stride * sizeof (CARD16);
      width>>=4;

      unsigned int p1, p2;
      unsigned int color_changes=0;
      unsigned int pixels=0;
      unsigned int data=0;
      unsigned int lastrow=0;

      short key=0;
      short p1on=0;
      short p2on=0;

      /* for each scanline */
      for(y=0; y<height; y++)
      {
	/* set pointer to right position */
	srcp = isrc+y*sstride;

	p1=0;
	p2=0;
	p1on=0;
	p2on=0;
	pixels=0;
	color_changes=0;
	key=-1;

	// scan scanline pixel by pixel
	for (x=0; x<width; x++, srcp++)
	{
	  /* not a colorkey --> startpos */
	  if (*srcp != ckey)
	  {
	    pixels++;
	    data++;

	    if (key!=0) {color_changes++;}
	    key=0;

	    if (!p1on)
	    {
	      p1 = x;
	      p1on=1;
	    }
	  }

	  else
	  {
	    if (key!=1) {color_changes++;}
	    key=1;
	    /* startpos marked, no endpos yet --> endpos */
	    if (p1on && !p2on)
	    {
	      p2 = x;
	      p2on=1;
	    }
	  }

	} /* SCANLINE */


	if (color_changes > 3)
	{
	  /* complex type, pixel by pixel */
	  p1 = 0;
	  p2 = 0;
	  pdata->type = XCK_COMPLEX;
	}

	else
	{
	  /* maybe empty line ? */
	  if (pixels == 0)
	  {
	    p1 = 0;
	    p2 = 0;
	  }
	  /* transparency @ scanline tail or short line? */
	  else
	  {
	    if (p2 <= p1)
	      p2 = width;
	  }
	}

	/* position and the bytecount for memcpy */
	*pos_table++ = p1;
	*pos_table++ = p2 - p1;

	/* we can skip the whole row */
	if (data == 0)
	{
	  pdata->u_offset++; /* up offset */
	}

	if (pixels > 0)
	{
	  lastrow=y;
	}

      } /* for each scanline */

      /* down offset */
      pdata->d_offset = height-lastrow-1;

      if (pdata->type != XCK_COMPLEX)
      {
	if ((data*bpp) == totalbytes)
	  pdata->type = XCK_NORMAL;
	else
	  pdata->type = XCK_OPTIMIZE;
      }

      /* free optimizing table if no use for them */
      if (pdata->type == XCK_COMPLEX || pdata->type == XCK_NORMAL)
      {
	xfree(pdata->position_map);
	pdata->position_map = NULL;
      }

    }
} /* scan */
