#ifndef _OMAP_H_
#define _OMAP_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdint.h>
#include <fbdev.h>
#include <scrnintstr.h>
#include "kdrive.h"
#include "cursor.h"
#include "cursorstr.h"
#include "picturestr.h"



/* #define DEBUG */
#ifdef DEBUG
#define DBGOUT(fmt,a...) fprintf (stderr, fmt, ##a)
#else
#define DBGOUT(fmt,a...)
#endif

#define ENTER() DBGOUT("Enter %s\n", __FUNCTION__)
#define LEAVE() DBGOUT("Leave %s\n", __FUNCTION__)


#define wrap(priv, real, mem, func) {\
    priv->mem = real->mem; \
    real->mem = func; \
}

#define unwrap(priv, real, mem) {\
    real->mem = priv->mem; \
}


#define OMAP_DMG_ACCTIME 50000 // in microseconds

typedef struct _omapCardInfo {
    union {
        FbdevPriv fbdev;
    } backend_priv;
} OmapCardInfo;

#define getOmapCardInfo(kd)      ((OmapCardInfo *) ((kd)->card->driver))
#define omapCardInfo(kd)         OmapCardInfo *omapc = getOmapCardInfo(kd)


typedef struct _omapScreenInfo {
    union {
        FbdevScrPriv fbdev;
    } backend_priv;
    KaaScreenInfoRec kaa;
    OmapCardInfo *omapc;
    KdScreenInfo *screen;

    unsigned int damage_id_index;
    uint64_t last_update; /* last tornado update in microseconds*/
    BoxRec odb; /* next tornado update will flush this area */

    /* wrapped screen functions */

    PaintWindowBackgroundProcPtr PaintWindowBackground;
    PaintWindowBorderProcPtr    PaintWindowBorder;
    CopyWindowProcPtr           CopyWindow;
    CloseScreenProcPtr          CloseScreen;
    CreateGCProcPtr             CreateGC;
    DestroyPixmapProcPtr        DestroyPixmap;
    SetWindowPixmapProcPtr      SetWindowPixmap;
    DestroyWindowProcPtr        DestroyWindow;
#ifdef RENDER
    CompositeProcPtr            Composite;
    GlyphsProcPtr               Glyphs;
#endif
    BSFuncRec                   BackingStoreFuncs;

} OmapScreenInfo;

extern int omapGCPrivateIndex;

typedef struct _omapGCPriv {
    GCOps   *ops;
    GCFuncs *funcs;
} OmapGCPrivRec, *OmapGCPrivPtr;

#define getOmapScreenInfo(kd)    ((OmapScreenInfo *) ((kd)->screen->driver))
#define omapScreenInfo(kd)       OmapScreenInfo *omaps = getOmapScreenInfo(kd)
#define omapGetGCPriv(pGC)       ((OmapGCPrivPtr) (pGC)->devPrivates[omapGCPrivateIndex].ptr)
#define omapGCPriv(pGC)          OmapGCPrivPtr  pGCPriv = omapGetGCPriv(pGC)

typedef struct _omapDamageBox {
    unsigned int id;
    BoxRec box;
    OmapScreenInfo *omaps;
} OmapDamageBox, *OmapDamageBoxPtr;

typedef struct _omapDamageRegion {
    int count;
    OmapDamageBoxPtr box;
} OmapDamageRegion, *OmapDamageRegionPtr;

Bool omapDrawInit(ScreenPtr pScreen);
void omapDrawEnable(ScreenPtr pScreen);
void omapDrawDisable(ScreenPtr pScreen);
void omapDrawFini(ScreenPtr pScreen);
void omapDrawSync(ScreenPtr pScreen);

void omapSendDamage(OmapDamageBoxPtr od);
void omapTornadoUpdatePump(int force);

#define TRIM_BOX(box, pGC) { \
    BoxPtr extents = &pGC->pCompositeClip->extents;\
    if(box.x1 < extents->x1) box.x1 = extents->x1; \
    if(box.x2 > extents->x2) box.x2 = extents->x2; \
    if(box.y1 < extents->y1) box.y1 = extents->y1; \
    if(box.y2 > extents->y2) box.y2 = extents->y2; \
}

#define TRANSLATE_BOX(box, pDrawable) { \
    box.x1 += pDrawable->x; \
    box.x2 += pDrawable->x; \
    box.y1 += pDrawable->y; \
    box.y2 += pDrawable->y; \
}

#define TRIM_AND_TRANSLATE_BOX(box, pDrawable, pGC) { \
    TRANSLATE_BOX(box, pDrawable); \
    TRIM_BOX(box, pGC); \
}

#define BOX_NOT_EMPTY(box) \
    (((box.x2 - box.x1) > 0) && ((box.y2 - box.y1) > 0))

#define BOX_SAME(a,b) \
    ((a)->x1 == (b)->x1 && \
     (a)->y1 == (b)->y1 && \
     (a)->x2 == (b)->x2 && \
     (a)->y2 == (b)->y2)

Bool omapCreateGC(GCPtr pGC);

PixmapPtr omapGetDrawablePixmap(DrawablePtr pDrawable);

/* #define DEBUG_ODB 1 */

#ifndef DEBUG_ODB
OmapDamageRegionPtr omapDamageRegion(DrawablePtr pDrawable, RegionPtr pRegion, Bool clip);
OmapDamageBoxPtr omapDamageBox(DrawablePtr pDrawable, BoxPtr pBox);
#else
OmapDamageRegionPtr _omapDamageRegion(char *func, DrawablePtr pDrawable, RegionPtr pRegion, Bool clip);
OmapDamageBoxPtr _omapDamageBox(char *func, DrawablePtr pDrawable, BoxPtr pBox);
#define omapDamageRegion(a...) _omapDamageRegion(__FUNCTION__, ##a)
#define omapDamageBox(a...) _omapDamageBox(__FUNCTION__, ##a)
#endif

extern KdKeyboardFuncs omapKeyboardFuncs;
extern KdCardFuncs omapFuncs;



/* IOCTL commands for DSP */

/*
 * for /dev/dspctl/ctl
 */

#define OMAP_DSP_IOCTL_FBEN			53
#define OMAP_DSP_IOCTL_FBDIS			54


#endif /* _OMAP_H_ */
