/*
 * This file is part of certman
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Contact: Ed Bartosh <Eduard.Bartosh@nokia.com>
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/**
   @file cst_crypt.h

   Crypt and file related functions and structures
*/

#ifndef CST_CRYPT_H_
#define CST_CRYPT_H_

#include <stdlib.h>
#include <openssl/bio.h>
#include <openssl/evp.h>

#ifdef __cplusplus
extern "C" {
#endif

//#define SECURE

/* Storage file description structure */
    typedef struct CRYPT_FILE_st {
#ifdef SECURE
        BIO *file;
        BIO *buffer;
        //BIO *b64;
        BIO *cipher;
#else
        FILE *fp;
#endif
    } CRYPT_FILE;

/**
    Open crypt reader object
*/
    CRYPT_FILE *crypt_reader_open(const char *filename, char *password);

/**
    Open crypt writer
*/
    CRYPT_FILE *crypt_writer_open(const char *filename, char *password);

/**
    Close crypt reader
*/
    void crypt_reader_close(CRYPT_FILE * cf);

/**
    Close crypt writer
*/
    void crypt_writer_close(CRYPT_FILE * cf);

/**
    Read to buffer
*/
    int crypt_reader_get(CRYPT_FILE * cf, void *buffer, int len);

/**
    Write from buffer
*/
    int crypt_writer_put(CRYPT_FILE * cf, void *buffer, int len);

/**
    EOF of crypt reader
*/
    int crypt_reader_eof(CRYPT_FILE * cf);

#ifdef __cplusplus
}
#endif
#endif                          /* CST_CRYPT_H_ */
