/*
 * This file is part of certman
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Contact: Ed Bartosh <Eduard.Bartosh@nokia.com>
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/**
   @file cst_const.h

   Const ant types
*/

#ifndef CST_CONST_H_
#define CST_CONST_H_

#include <glib.h>
//#include "cst_crypt.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Set here default filename of storage */
#define DEFAULT_FILENAME "storage.cst"

/* Set here gconf key for default filename */
#define DEFAULT_GCONF_KEY_FILENAME "/apps/osso/certman/filename"

/* Set here algorithm whish used by default for encoding */
#define DEFAULT_ALGORITHM EVP_des_ede3_cbc()

/* Default password - used if password NULL */
#define DEFAULT_PASSWORD "defpass"    
    
/* Typedefs used for local storage */
    typedef guint8 t_bool;
#define sz_bool sizeof(t_bool)

    typedef guint8 t_rtype;
#define sz_rtype sizeof(t_rtype)

    typedef guint32 t_rsize;
#define sz_rsize sizeof(t_rsize)
#define RSIZE_FROM_LE(val) GUINT32_FROM_LE(val)
#define RSIZE_TO_LE(val) GUINT32_TO_LE(val)

#define sz_rheader sz_rtype + sz_rsize

    typedef guint32 t_cert_purpose;     /* see: cst.h */
#define sz_cert_purpose sizeof(t_cert_purpose)
#define CERT_PURPOSE_FROM_LE(val) GUINT32_FROM_LE(val)
#define CERT_PURPOSE_TO_LE(val) GUINT32_TO_LE(val)

    typedef guint8 t_cert_folder;       /* see: cst.h */
#define sz_cert_folder sizeof(t_cert_folder)

    typedef guint32 t_key_type;
#define sz_key_type sizeof(t_key_type)
#define KEY_TYPE_FROM_LE(val) GUINT32_FROM_LE(val)
#define KEY_TYPE_TO_LE(val) GUINT32_TO_LE(val)

    typedef guint t_seqnum;             /* see: cst.h */
#define sz_seqnum sizeof(t_seqnum)
#define SEQNUM_FROM_LE(val) GUINT_FROM_LE(val)    
#define SEQNUM_TO_LE(val) GUINT_TO_LE(val)
#define SEQNUM_TO_POINTER(val) GUINT_TO_POINTER(val)    
#define SEQNUM_FROM_POINTER(val) GPOINTER_TO_UINT(val)

    typedef guint64 t_mcount;
#define sz_mcount sizeof(t_mcount)
#define MCOUNT_FROM_LE(val) GUINT64_FROM_LE(val)
#define MCOUNT_TO_LE(val) GUINT64_TO_LE(val)
    
/* Record types. Used for implement local storage. */
#define CST_RT_CERT     1
#define CST_RT_KEY      2
#define CST_RT_CRL      3
#define CST_RT_MAIN     4    

#define CST_RT_PURPOSE      100
#define CST_RT_FOLDER       101
#define CST_RT_BODY         104
#define CST_RT_NAME         105
#define CST_RT_PUB          106
#define CST_RT_ENC          107
#define CST_RT_KEY_TYPE     108
#define CST_RT_SERIAL       109
#define CST_RT_DEF          110
#define CST_RT_ISSUER_NAME  111
#define CST_RT_CAPAB_OID    112
#define CST_RT_CAPAB_DATA   114
#define CST_RT_NEXTCERTID   115   
#define CST_RT_NEXTKEYID    116    
#define CST_RT_CERTLINK     117 
#define CST_RT_KEYLINK      118    
#define CST_RT_ISREVOKED    119    


/* Suffixes for dbkey */
#define CST_SUFFIX_CERTBODY "CB"
#define CST_SUFFIX_CERTINFO "CI"
#define CST_SUFFIX_KEYINFO  "KI"  
#define CST_SUFFIX_CRLINFO  "CRL"
#define CST_SUFFIX_MCOUNT   "MCOUNT"
    
#ifdef __cplusplus
}
#endif
#endif                          /* CST_CONST_H_ */
