#ifndef _OMAPFB_H_
#define _OMAPFB_H_

#include <linux/fb.h>


/* IOCTL commands. */

#define OMAP_IOW(num, dtype)    _IOW('O', num, dtype)
#define OMAP_IOR(num, dtype)    _IOR('O', num, dtype)
#define OMAP_IOWR(num, dtype)   _IOWR('O', num, dtype)
#define OMAP_IO(num)            _IO('O', num)

#define OMAPFB_FILLRECT         OMAP_IOW(0, struct fb_fillrect)
#define OMAPFB_COPYAREA         OMAP_IOW(1, struct fb_copyarea)
#define OMAPFB_IMAGEBLIT        OMAP_IOW(2, struct fb_image)

#define OMAPFB_TRANSPARENT_BLIT OMAP_IOW(30, struct fb_image)
#define OMAPFB_MIRROR           OMAP_IOW(31, int)
#define OMAPFB_SCALE            OMAP_IOW(32, struct fb_scale)
#define OMAPFB_SELECT_VIS_FRAME OMAP_IOW(33, int)
#define OMAPFB_SELECT_SRC_FRAME OMAP_IOW(34, int)
#define OMAPFB_SELECT_DST_FRAME OMAP_IOW(35, int)
#define OMAPFB_GET_FRAME_OFFSET OMAP_IOWR(36, struct fb_frame_offset)
#define OMAPFB_SYNC_GFX         OMAP_IO(37)
#define OMAPFB_VSYNC            OMAP_IO(38)
#define OMAPFB_LATE_ACTIVATE    OMAP_IO(39)
#define OMAPFB_SET_UPDATE_MODE  OMAP_IOW(40, enum fb_update_mode)
#define OMAPFB_UPDATE_WINDOW    OMAP_IOW(41, struct fb_update_window)
#define OMAPFB_GET_CAPS		OMAP_IOR(42, unsigned long)

enum fb_update_mode {
	FB_UPDATE_DISABLED = 0,
	FB_AUTO_UPDATE,
	FB_MANUAL_UPDATE
};

struct fb_scale {
	unsigned int xscale, yscale;
};

struct fb_frame_offset {
	unsigned int idx;
	unsigned long offset;
};

struct fb_update_window {
	unsigned int x, y;
	unsigned int width, height;
};

#endif
