/**
  @file osso-ic-gconf.h

  osso-ic-oss Internet Connectivity library
  Copyright (C) 2005 Nokia Corporation

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2.1 of the License, or (at
  your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  */

#ifndef OSSO_IC_GCONF_H
#define OSSO_IC_GCONF_H

#ifdef __cplusplus
extern "C" {
#endif

/** GConf path of ICd related configuration data */
#define ICD_GCONF_PATH			"/system/osso/connectivity/IAP"

/** The name of currently active IAP (string) */
#define ICD_GCONF_CURRENT		ICD_GCONF_PATH "/current"

/** The name of preferred IAP (string) */
#define ICD_GCONF_PREFERRED_IAP		ICD_GCONF_PATH "/preferred_iap"

/** Should the preferred IAP be used without asking (boolean) */
#define ICD_GCONF_USE_PREFERRED		ICD_GCONF_PATH "/use_preferred"

/** Is WLAN allowed during flight mode? (boolean) */
#define ICD_GCONF_FLIGHTMODE_WLAN	ICD_GCONF_PATH "/flightmode_wlan"

/** WLAN TX power level (integer) */
#define ICD_GCONF_WLAN_TX_POWER		ICD_GCONF_PATH "/wlan_tx_power"

/** Idle timeout for WLAN connections (integer) */
#define ICD_GCONF_TIMEOUT_WLAN		ICD_GCONF_PATH "/timeout_wlan"

/** Idle timeout for DUN CS connections (integer) */
#define ICD_GCONF_TIMEOUT_DUN_CS	ICD_GCONF_PATH "/timeout_dun_cs"

/** Idle timeout for DUN PS connections (integer) */
#define ICD_GCONF_TIMEOUT_DUN_PS	ICD_GCONF_PATH "/timeout_dun_ps"

#ifdef __cplusplus
}
#endif

#endif /* OSSO_IC_GCONF_H */
