/**
  @file osso-ic-dbus.h

  osso-ic-oss Internet Connectivity library
  Copyright (C) 2005 Nokia Corporation

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2.1 of the License, or (at
  your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  */

#ifndef OSSO_IC_DBUS_H
#define OSSO_IC_DBUS_H

#ifdef __cplusplus
extern "C" {
#endif

/** D-BUS stuff related to ICd */
#define ICD_DBUS_SERVICE		"com.nokia.icd"

#define ICD_DBUS_INTERFACE		"com.nokia.icd"
#define ICD_DBUS_PATH			"/com/nokia/icd"

#define ICD_CONNECT_REQ			"connect"
#define ICD_DISCONNECT_REQ		"disconnect"
#define ICD_ACTIVATE_REQ		"activate"
#define ICD_SHUTDOWN_REQ		"shutdown"
#define ICD_GET_STATE_REQ		"get_state"
#define ICD_GET_STATISTICS_REQ		"get_statistics"
#define ICD_GET_IPINFO_REQ		"get_ipinfo"
#define ICD_STATUS_CHANGED_SIG		"status_changed"

#define ICD_DBUS_AUTOCONF_INTERFACE	"com.nokia.icd.autoconf"
#define ICD_DBUS_AUTOCONF_PATH		"/com/nokia/icd/autoconf"

#define ICD_AUTOCONF_CHANGED_SIG	"autoconf_changed"

#define ICD_DBUS_ERROR_SYSTEM_ERROR	"com.nokia.icd.error.system_error"
#define ICD_DBUS_ERROR_GATEWAY_ERROR	"com.nokia.icd.error.gateway_error"
#define ICD_DBUS_ERROR_AUTH_FAILED	"com.nokia.icd.error.authentication_failed"
#define ICD_DBUS_ERROR_SERVER_ERROR	"com.nokia.icd.error.server_error"
#define ICD_DBUS_ERROR_NETWORK_ERROR	"com.nokia.icd.error.network_error"
#define ICD_DBUS_ERROR_WPA2_NOT_SUPPORTED "com.nokia.icd.error.wpa2_not_supported"
#define ICD_DBUS_ERROR_SAP_NOT_SUPPORTED  "com.nokia.icd.error.sap_not_supported"
#define ICD_DBUS_ERROR_SAP_CONNECT_FAILED "com.nokia.icd.error.sap_connect_failed"
#define ICD_DBUS_ERROR_SAP_NO_PHONE	"com.nokia.icd.error.sap_no_phone"
#define ICD_DBUS_ERROR_FLIGHT_MODE	"com.nokia.icd.error.flight_mode"

#define ICD_DBUS_ERROR_INVALID_IAP	"com.nokia.icd.error.invalid_iap"
#define ICD_DBUS_ERROR_IAP_IN_USE	"com.nokia.icd.error.iap_in_use"
#define ICD_DBUS_ERROR_IAP_NOT_AVAILABLE \
					"com.nokia.icd.error.iap_not_available"

/** D-BUS stuff related to GW HW detection */
#define GWHWD_DBUS_SERVICE		"com.nokia.gwhw_detect"

#define GWHWD_DBUS_INTERFACE		"com.nokia.gwhw_detect"
#define GWHWD_DBUS_PATH			"/com/nokia/gwhw_detect"

#define GWHWD_DETECT_REQ		"detect"

#define GWHWD_DBUS_ERROR		"com.nokia.gwhw_detect.error"

#ifdef __cplusplus
}
#endif

#endif /* OSSO_IC_DBUS_H */
