/* -*- Mode: C; c-basic-offset: 8; indent-tabs-mode: t -*- */

/*
  osso-ic-oss Internet Connectivity library
  Copyright (C) 2005 Nokia Corporation

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2.1 of the License, or (at
  your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  This is an example program how to use the Internet Connectivity Socket
  interface. It connects to an HTTP server, issues a simple GET request and
  prints the output from the server to stdout.

  Compile it with the command:

	gcc osso-socket.c -o osso-socket \
	`pkg-config --cflags --libs osso-ic glib-2.0` \
	-DDBUS_API_SUBJECT_TO_CHANGE

  To run, provide hostname and port as arguments:

	./osso-socket www.maemo.org 80
  
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
#include <sys/types.h>
#include <string.h>
#include <netdb.h>

#include <osso-ic.h>

#define BUFFER_SIZE 200
#define GET_REQUEST "GET / HTTP/1.0\n\n"

int main(int argc, char **argv)
{
	int fd, bytes;
	char buf[BUFFER_SIZE];
	struct addrinfo hints, *addrinfo;


	if (argc != 3) {
		printf("Usage: %s hostname port\n", argv[0]);
		exit(1);
	}

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	if (getaddrinfo(argv[1], argv[2], &hints, &addrinfo) != 0){
		printf("getaddrinfo() failed.");
		exit(1);
	}
	
	fd = osso_socket(addrinfo->ai_family, addrinfo->ai_socktype,
			 addrinfo->ai_protocol);

	if (fd == -1) {
		perror("socket error");
		exit(1);
	}
	
	if (connect(fd, addrinfo->ai_addr, addrinfo->ai_addrlen) == -1) {
		perror("could not connect");
	}
	
	if (send(fd, GET_REQUEST, 16, 0) == -1) {
		perror("could not send");
		exit(1);
	}
	
	while ((bytes = recv(fd, buf, BUFFER_SIZE - 1, 0)) > 0) {
		buf[bytes] = '\0';
		printf(buf);
	}

	if (bytes == -1) {
		perror("receive error");
		exit(1);
	}

	osso_close(fd);

	return 0;
}
