/**
  @file dbus-helper.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _DBUS_HELPER_H_
#define _DBUS_HELPER_H_

#include <glib.h>
#include <dbus/dbus.h>


#if 0
void append_dbus_iter_args(DBusMessageIter *iter, int first_arg_type, ...);
#endif

char *dbus_strdup(const char *str);

gboolean get_dbus_iter_args(DBusMessageIter *iter, int first_arg_type, ...);

void append_dbus_args(DBusMessage *message, int first_arg_type, ...);

gboolean get_dbus_args(DBusMessage *message, int first_arg_type, ...);


gboolean send_and_unref(DBusConnection *connection, DBusMessage *message);

gboolean send_invalid_args(DBusConnection *connection, DBusMessage *message);

DBusMessage *new_dbus_signal(const char *path,
                             const char *interface,
                             const char *name,
                             const char *destination);

DBusMessage *new_dbus_method_call(const char *service,
                                  const char *path,
                                  const char *interface,
                                  const char *method);

DBusMessage *new_dbus_method_return(DBusMessage *message);

DBusMessage *new_dbus_error(DBusMessage *message, const char *name, const char *msg);

DBusMessage *new_dbus_error_gerr(DBusMessage *message, GError *err);

/** Get device mode from MCE
 * @param connection D-BUS connection to use
 * @returns device mode (as reported by MCE, should be "flight" or "normal")
 */
gchar *get_device_mode(DBusConnection *connection);

/** Add a function to be called when device mode changes (reported by a D-BUS
 * signal from MCE)
 * @param connection D-BUS connection to listen for MCE signals on
 * @param mode_cb function to call when the mode changes
 * @returns TRUE on success, FALSE on failure
 */
#ifdef USE_MCE
gboolean add_mode_listener(DBusConnection *connection,
                           void (*mode_cb)(const gchar *mode));

#endif

#endif /* _DBUS_HELPER_H_ */
