/**
  @file btsearch-bt.c

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <glib.h>

#include "log.h"
#include "dbus.h"
#include "dbus-helper.h"
#include "btsearch-bt.h"

gboolean bt_ok(void) {
    gboolean ret;
    gchar *mode;

    mode = get_device_mode(get_dbus_connection());
    if (mode == NULL) {
        error("get_device_mode() returned NULL!");
        /* Assume that BT is usable */
        return TRUE;
    }

    if (g_str_equal(mode, "normal"))
        ret = TRUE;
    else
        ret = FALSE;

    g_free(mode);

    return ret;
}
