/**
  @file btsdp-bt.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BTSDP_BT_H_
#define _BTSDP_BT_H_

#include <stdint.h>
#include <glib.h>
#include "btsdp-dbus.h"

#define BT_DEV_ID 0

#define SDP_SERVICE_RFCOMM    ((int)'r')
#define SDP_SERVICE_ERROR     ((int)'E')

#define SDP_SERVICE_ID_UUID   ((int)'u')
#define SDP_SERVICE_ID_STRING ((int)'s')

typedef struct {
    int      type;
    char    *service;
    uint8_t  channel;
} sdp_info_t;

typedef struct {
    int type;
    union {
        uint16_t  uuid;
        char     *string;
    } u;
} SdpServiceId;

void free_sdp_info(sdp_info_t *info, gpointer user_data);

gboolean get_services(const char *bda, GSList *l, uint16_t clock,
                      sdp_cb_data_t *data, GError **err);

gboolean bt_ok(void);

#endif /* _BTSDP_BT_H_ */
