/**
  @file btcond-signals.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BTCOND_SIGNALS_H_
#define _BTCOND_SIGNALS_H_

#include "btcond-hci.h"

/** Send connection_status signal to system D-Bus broadcast address
 * @param event State change information
 **/
void send_dbus_connection_status(con_evt_t *event);

void send_dbus_rfcomm_status(const char *bda, const char *svc, const char *status);

void send_dbus_pin_req(con_evt_t *event);

void send_dbus_cc_failed(con_evt_t *event);

void send_dbus_auth_failed(con_evt_t *event);

void send_dbus_link_key_ok(con_evt_t *event);

void send_dbus_hci_dev_up(const char *dev);

void send_dbus_hci_dev_down(const char *dev);

#endif /* _BTCOND_SIGNALS_H_ */
