/**
  @file btcond-hci.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BTCOND_HCI_H_
#define _BTCOND_HCI_H_

#include <stdint.h>
#include <glib.h>

#define EVT_TYPE_INVALID        0xFF
#define EVT_TYPE_CC             0x00
#define EVT_TYPE_DC             0x01
#define EVT_TYPE_CC_FAIL        0x02
#define EVT_TYPE_PIN_REQ        0x03
#define EVT_TYPE_LINK_KEY       0x04 
#define EVT_TYPE_AUTH_FAILED    0x05 

typedef struct {
    uint8_t type;
    uint8_t status;
    uint16_t handle;
    char *bda;
    uint8_t dc_reason; /* Only used for disconnect events */
} con_evt_t;

/** Listen for HCI events
 * @returns TRUE on success, FALSE on failure
 */
gboolean monitor_connections(GError **err);

gboolean hci_bt_up(void);

gboolean hci_bt_down(void);

#endif /* _BTCOND_HCI_H_ */
