/**
  @file bt-dbus.h

  Bluetooth connectivity D-BUS API names

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BT_DBUS_H_
#define _BT_DBUS_H_

/* BT Connection Daemon defines */
#define BTCOND_SERVICE                      "com.nokia.btcond"
#define BTCOND_REQ_INTERFACE                "com.nokia.btcond.request"
#define BTCOND_SIG_INTERFACE                "com.nokia.btcond.signal"
                                            
#define BTCOND_SIG_PATH                     "/com/nokia/btcond/signal"
#define BTCOND_REQ_PATH                     "/com/nokia/btcond/request"
                                            
#define BTCOND_CONNECTION_STATUS_SIG        "connection_status"
#define BTCOND_RFCOMM_STATUS_SIG            "rfcomm_status"
#define BTCOND_CONNECT_FAILED_SIG           "connect_failed"
#define BTCOND_AUTH_FAILED_SIG              "auth_failed"
#define BTCOND_PIN_REQ_SIG                  "pin_req"
#define BTCOND_LINK_KEY_OK_SIG              "link_key_ok"
#define BTCOND_HCI_DEV_UP_SIG               "hci_dev_up"
#define BTCOND_HCI_DEV_DOWN_SIG             "hci_dev_down"
                                            
#define BTCOND_CONNECTION_STATUS_REQ        "connection_status"
#define BTCOND_UPDATE_DEV_INFO_REQ          "update_dev_info"
#define BTCOND_RFCOMM_STATUS_REQ            "rfcomm_status"
#define BTCOND_DISCONNECT_REQ               "disconnect"
#define BTCOND_DEV_CAPABILITY_REQ           "get_dev_capability"
#define BTCOND_RFCOMM_CONNECT_REQ           "rfcomm_connect"
#define BTCOND_RFCOMM_DISCONNECT_REQ        "rfcomm_disconnect"
#define BTCOND_RFCOMM_BIND_REQ              "rfcomm_bind"
#define BTCOND_RFCOMM_RELEASE_REQ           "rfcomm_release"
#define BTCOND_RFCOMM_CANCEL_CONNECT_REQ    "rfcomm_cancel_connect"
#define BTCOND_GET_BDA_LIST_REQ             "get_bda_list"
                                            
#define BTCOND_ERROR                        BTCOND_SERVICE ".error."
#define BTCOND_ERROR_INVALID_SVC            BTCOND_ERROR "invalid_svc"
#define BTCOND_ERROR_INVALID_DEV            BTCOND_ERROR "invalid_dev"
#define BTCOND_ERROR_CONNECTED              BTCOND_ERROR "connected"
#define BTCOND_ERROR_BOUND                  BTCOND_ERROR "bound"
#define BTCOND_ERROR_NOT_CONNECTED          BTCOND_ERROR "not_connected"
#define BTCOND_ERROR_DISCONNECTED           BTCOND_ERROR_NOT_CONNECTED
#define BTCOND_ERROR_NOT_BOUND              BTCOND_ERROR "not_bound"
#define BTCOND_ERROR_BT_DISABLED            BTCOND_ERROR "bt_disabled"
#define BTCOND_ERROR_CONNECT_FAILED         BTCOND_ERROR "connect_failed"
#define BTCOND_ERROR_NO_DEV_INFO            BTCOND_ERROR "no_dev_info"
#define BTCOND_ERROR_AUTH_FAILED            BTCOND_ERROR "auth_failed"
#define BTCOND_ERROR_SMALL_CRYPT_KEY        BTCOND_ERROR "small_crypt_key"
#define BTCOND_ERROR_CANCELLED              BTCOND_ERROR "cancelled"
#define BTCOND_ERROR_INTERNAL               BTCOND_ERROR "internal"
                                    
/* BT Search Application defines */
#define BTSEARCH_SERVICE                    "com.nokia.btsearch"
#define BTSEARCH_REQ_INTERFACE              "com.nokia.btsearch.request"
#define BTSEARCH_SIG_INTERFACE              "com.nokia.btsearch.signal"
#define BTSEARCH_SIG_PATH                   "/com/nokia/btsearch/signal"
#define BTSEARCH_REQ_PATH                   "/com/nokia/btsearch/request"
                                    
#define BTSEARCH_START_SEARCH_REQ           "start_search"
#define BTSEARCH_STOP_SEARCH_REQ            "stop_search"
                                        
#define BTSEARCH_DEV_FOUND_SIG              "dev_found"
#define BTSEARCH_SEARCH_COMPLETE_SIG        "search_complete"

#define BTSEARCH_ERROR                      BTSEARCH_SERVICE ".error."
#define BTSEARCH_ERROR_BT_DISABLED          BTSEARCH_ERROR "bt_disabled"
#define BTSEARCH_ERROR_NO_SEARCH            BTSEARCH_ERROR "no_search"
#define BTSEARCH_ERROR_SEARCH_IN_PROGRESS   BTSEARCH_ERROR "search_in_progress"
#define BTSEARCH_ERROR_FAILED               BTSEARCH_ERROR "failed"

/* BT SDP Application defines */
#define BTSDP_SERVICE                       "com.nokia.btsdp"
#define BTSDP_REQ_INTERFACE                 "com.nokia.btsdp.request"
#define BTSDP_REQ_PATH                      "/com/nokia/btsdp/request"
                                    
#define BTSDP_GET_RFCOMM_SERVICES_REQ       "get_rfcomm_services"
                                        
#define BTSDP_ERROR                         BTSDP_SERVICE ".error."
#define BTSDP_ERROR_BT_DISABLED             BTSDP_ERROR "bt_disabled"
#define BTSDP_ERROR_CONNECT_FAILED          BTSDP_ERROR "connect_failed"
#define BTSDP_ERROR_QUERY_IN_PROGRESS       BTSDP_ERROR "query_in_progress"
#define BTSDP_ERROR_FAILED                  BTSDP_ERROR "failed"

#endif /* _BT_DBUS_H_ */
