/**
  @file bt-cod.h
  
  BT Class of Device macros and functions

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */
#ifndef _BT_COD_H_
#define _BT_COD_H_

#include <stdint.h>

/* Major Service Classes */
#define MAJOR_SVC_LIMITED_DISCOVERY_MODE(cod)   ((cod)[1] & (1<<5))
#define MAJOR_SVC_NETWORKING(cod)               ((cod)[2] & (1<<1))
#define MAJOR_SVC_RENDERING(cod)                ((cod)[2] & (1<<2))
#define MAJOR_SVC_CAPTURING(cod)                ((cod)[2] & (1<<3))
#define MAJOR_SVC_OBJECT_XFER(cod)              ((cod)[2] & (1<<4))
#define MAJOR_SVC_AUDIO(cod)                    ((cod)[2] & (1<<5))
#define MAJOR_SVC_TELEPHONY(cod)                ((cod)[2] & (1<<6))
#define MAJOR_SVC_INFORMATION(cod)              ((cod)[2] & (1<<7))

/* Major Device Classes */
#define MAJOR_DEV_MISCELLANEOUS(cod)            (((cod)[1] & 0x1F) == 0x00)
#define MAJOR_DEV_COMPUTER(cod)                 (((cod)[1] & 0x1F) == 0x01)
#define MAJOR_DEV_PHONE(cod)                    (((cod)[1] & 0x1F) == 0x02)
#define MAJOR_DEV_LAN_ACCESS(cod)               (((cod)[1] & 0x1F) == 0x03)
#define MAJOR_DEV_AUDIO(cod)                    (((cod)[1] & 0x1F) == 0x04)
#define MAJOR_DEV_PERIPHERAL(cod)               (((cod)[1] & 0x1F) == 0x05)
#define MAJOR_DEV_UNCLASSIFIED(cod)             (((cod)[1] & 0x1F) == 0x1F)

/* Minor Device Class field - Computer Major Class */
#define COMPUTER_UNCLASSIFIED(cod)              (((cod)[0] & 0xFC) == 0x00)
#define COMPUTER_DESKTOP(cod)                   (((cod)[0] & 0xFC) == 0x08)
#define COMPUTER_SERVER(cod)                    (((cod)[0] & 0xFC) == 0x09)
#define COMPUTER_LAPTOP(cod)                    (((cod)[0] & 0xFC) == 0x0A)
#define COMPUTER_HANDHELD(cod)                  (((cod)[0] & 0xFC) == 0x0B)
#define COMPUTER_PALM(cod)                      (((cod)[0] & 0xFC) == 0x0C)

/* Minor Device Class field - Phone Major Class */
#define PHONE_UNCLASSIFIED(cod)                 (((cod)[0] & 0xFC) == 0x00)
#define PHONE_CELLULAR(cod)                     (((cod)[0] & 0xFC) == 0x08)
#define PHONE_CORDLESS(cod)                     (((cod)[0] & 0xFC) == 0x09)
#define PHONE_SMART_PHONE(cod)                  (((cod)[0] & 0xFC) == 0x0A)
#define PHONE_WIRED_MODEM(cod)                  (((cod)[0] & 0xFC) == 0x0B)

/* Minor Device Class field - Audio Major Class */
#define AUDIO_HEADSET_PROFILE(cod)              (((cod)[0] & 0xFC) == 0x08)


#if 0
/* The following are example functions showing how to use the
 * macros in this file.
 */

static inline const char *strclass_phone(uint8_t cod[3]) {
    if (PHONE_CELLULAR(cod))
        return "Phone (Cellular)";
    else if (PHONE_CORDLESS(cod))
        return "Phone (Cordless)";
    else if (PHONE_SMART_PHONE(cod))
        return "Phone (Smart phone)";
    else if (PHONE_WIRED_MODEM(cod))
        return "Phone (Wired modem)";
    else
        return "Phone";
}

static inline const char *strclass_computer(uint8_t cod[3]) {
    if (COMPUTER_DESKTOP(cod))
        return "Computer (Desktop)";
    else if (COMPUTER_SERVER(cod))
        return "Computer (Server)";
    else if (COMPUTER_LAPTOP(cod))
        return "Computer (Laptop)";
    else if (COMPUTER_HANDHELD(cod))
        return "Computer (Handheld)";
    else if (COMPUTER_PALM(cod))
        return "Computer (Palm)";
    else
        return "Computer";
}

static inline const char *strclass_major_dev(uint8_t cod[3]) {
    if (MAJOR_DEV_COMPUTER(cod))
        return strclass_computer(cod);
    else if (MAJOR_DEV_PHONE(cod))
        return strclass_phone(cod);
    else if (MAJOR_DEV_LAN_ACCESS(cod))
        return "LAN AP";
    else if (MAJOR_DEV_AUDIO(cod))
        return "Audio";
    else if (MAJOR_DEV_PERIPHERAL(cod))
        return "Peripheral";
    else if (MAJOR_DEV_MISCELLANEOUS(cod))
        return "Miscellaneous";
    else
        return "(unknown)";
}

static inline void print_major_svc(uint8_t cod[3]) {
    if (MAJOR_SVC_LIMITED_DISCOVERY_MODE(cod))
        printf("LimitedDiscovery ");
    if (MAJOR_SVC_NETWORKING(cod))
        printf("Networking ");
    if (MAJOR_SVC_RENDERING(cod))
        printf("Rendering ");
    if (MAJOR_SVC_CAPTURING(cod))
        printf("Capturing ");
    if (MAJOR_SVC_OBJECT_XFER(cod))
        printf("ObjectTransfer ");
    if (MAJOR_SVC_AUDIO(cod))
        printf("Audio ");
    if (MAJOR_SVC_TELEPHONY(cod))
        printf("Telephony ");
    if (MAJOR_SVC_INFORMATION(cod))
        printf("Information ");

    printf("\n");
} 

#endif /* if 0 */

#endif /* _BT_COD_H_ */
