/**
  @file key.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _KEY_H_
#define _KEY_H_

#include <glib.h>

#define DEFAULT_KEY_FILE "/etc/bluetooth/link_key"

gboolean have_link_key(const char *sba, const char *dba);

gboolean remove_link_key(const char *sba, const char *dba);

gboolean list_link_keys(const char *sba, const char *dba);

void key_file_init(const char *filename);

#endif
