/**
  @file io.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _IO_H_
#define _IO_H_

/** Read data from file descriptor
 * @param fd    File descriptor to read from
 * @param buf   Buffer to store the data
 * @param size  Amount of bytes to read
 * @returns     size on success, -1 on failure
 */
ssize_t io_read(int fd, void *buf, int size);

/** Write data to file descriptor
 * @param fd    File descriptor to write to
 * @param buf   Pointer to the data
 * @param size  Amount of bytes to write
 * @returns     size on success, -1 on failure
 */
ssize_t io_write(int fd, const void *buf, int size);

#endif /* _IO_H_ */
