/**
  @file dbus-helper.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _DBUS_HELPER_H_
#define _DBUS_HELPER_H_

#include <glib.h>
#include <dbus/dbus.h>


gboolean get_dbus_iter_args(DBusMessageIter *iter, int first_arg_type, ...);

void append_dbus_args(DBusMessage *message, int first_arg_type, ...);

gboolean get_dbus_args(DBusMessage *message, int first_arg_type, ...);


gboolean send_and_unref(DBusConnection *connection, DBusMessage *message);

gboolean send_dbus_error(DBusConnection *connection,
                         DBusMessage *message,
                         const gchar *name);

gboolean send_invalid_args(DBusConnection *connection, DBusMessage *message);

DBusMessage *new_dbus_signal(const char *path,
                             const char *interface,
                             const char *name,
                             const char *destination);

DBusMessage *new_dbus_method_call(const char *service,
                                  const char *path,
                                  const char *interface,
                                  const char *method);

DBusMessage *new_dbus_method_return(DBusMessage *message);

DBusMessage *new_dbus_error(DBusMessage *message, const char *name, const char *msg);


#endif /* _DBUS_HELPER_H_ */
