/**
  @file btpair-engine.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BTPAIR_ENGINE_H_
#define _BTPAIR_ENGINE_H_

#include <stdint.h>
#include <glib.h>

typedef struct pairing_context PairingContext;

typedef void (*btpair_cb)(GError *err, gpointer user_data);

PairingContext *pair_bda(const char *bda, uint16_t clock, gboolean encrypt,
                         btpair_cb cb, gpointer user_data, GError **err);

PairingContext *pair_handle(uint16_t handle, gboolean encrypt,
                            btpair_cb cb, gpointer user_data, GError **err);

void pair_cancel(PairingContext *ctx);


#endif /* _BTPAIR_ENGINE_H_ */
