#ifndef _OMAPFB_H_
#define _OMAPFB_H_

#include <linux/fb.h>


/* IOCTL commands for framebuffer */

#define OMAP_IOW(num, dtype)    _IOW('O', num, dtype)
#define OMAP_IOR(num, dtype)    _IOR('O', num, dtype)
#define OMAP_IOWR(num, dtype)   _IOWR('O', num, dtype)
#define OMAP_IO(num)            _IO('O', num)

#define OMAPFB_FILLRECT         OMAP_IOW(0, struct fb_fillrect)
#define OMAPFB_COPYAREA         OMAP_IOW(1, struct fb_copyarea)
#define OMAPFB_IMAGEBLIT        OMAP_IOW(2, struct fb_image)

#define OMAPFB_TRANSPARENT_BLIT OMAP_IOW(30, struct fb_image)
#define OMAPFB_MIRROR           OMAP_IOW(31, int)
#define OMAPFB_SCALE            OMAP_IOW(32, struct fb_scale)
#define OMAPFB_SELECT_VIS_FRAME OMAP_IOW(33, int)
#define OMAPFB_SELECT_SRC_FRAME OMAP_IOW(34, int)
#define OMAPFB_SELECT_DST_FRAME OMAP_IOW(35, int)
#define OMAPFB_GET_FRAME_OFFSET OMAP_IOWR(36, struct fb_frame_offset)
#define OMAPFB_SYNC_GFX         OMAP_IO(37)
#define OMAPFB_VSYNC            OMAP_IO(38)
#define OMAPFB_LATE_ACTIVATE    OMAP_IO(39)
#define OMAPFB_SET_UPDATE_MODE  OMAP_IOW(40, enum fb_update_mode)
#define OMAPFB_UPDATE_WINDOW    OMAP_IOW(41, struct fb_update_window)
#define OMAPFB_GET_CAPS         OMAP_IOR(42, unsigned long)
#define OMAPFB_GET_UPDATE_MODE  OMAP_IOW(43, enum fb_update_mode)
#define OMAPFB_GET_GFX_STATUS   OMAP_IOR(44, unsigned long)

#define FBCAPS_GENERIC_MASK     0x00000fff
#define FBCAPS_LCDC_MASK        0x00fff000
#define FBCAPS_PANEL_MASK       0xff000000

#define FBCAPS_MANUAL_UPDATE    0x00001000
#define FBCAPS_SET_BACKLIGHT    0x01000000

enum omapfb_gfx_status {
	OMAPFB_GFX_STATUS_OK    = 0,
	OMAPFB_GFX_STATUS_CHANGED
};

#define OMAPFB_UPDATE_FAILED    0x01
#define OMAPFB_FILLRECT_FAILED  0x02
#define OMAPFB_COPYAREA_FAILED  0x04
#define OMAPFB_IMGBLIT_FAILED   0x08

struct fb_copyarea_ext {
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
	__u32 sx;
	__u32 sy;
	__u32 trans_color;
	__u32 rev_dir;
};

struct fb_scale {
	unsigned int xscale, yscale;
};

struct fb_frame_offset {
	unsigned int idx;
	unsigned long offset;
};

struct fb_update_window {
	unsigned int x, y;
	unsigned int width, height;
};

enum fb_update_mode {
	FB_UPDATE_DISABLED = 0,
	FB_AUTO_UPDATE,
	FB_MANUAL_UPDATE
};


/* IOCTL commands for DSP */

/*
 * for /dev/dspctl/ctl
 */

#define OMAP_DSP_IOCTL_FBEN			53
#define OMAP_DSP_IOCTL_FBDIS			54

#endif
