#!/bin/sh
# Application Framework environment variable defines for all AF programs,
# programs started by AF startup scripts and the D-BUS session bus.

# Copyright (C) 2004-2005 Nokia Corporation.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA

# Global things
export AF_PIDDIR=/tmp/af-piddir
if [ ! -d $AF_PIDDIR ]; then
  # note, no write to flash involved here
  mkdir $AF_PIDDIR
fi

if [ "x$DISPLAY" = "x" ]; then
  export DISPLAY=:0.0
fi
export DBUS_SESSION_BUS_ADDRESS=unix:path=/tmp/session_bus_socket
export LAUNCHWRAPPER=/etc/osso-af-init/launch-wrapper.sh
MACH=`uname -m`
if [ "x$MACH" = "xarmv5tejl" -a -x /usr/sbin/dsmetool ]; then
  export LAUNCHWRAPPER_NICE=/etc/osso-af-init/nice-launch-wrapper.sh
  export LAUNCHWRAPPER_NICE_TRYRESTART=/etc/osso-af-init/nice-launch-wrapper-tryrestart.sh
  export LAUNCHWRAPPER_TRYRESTART=/etc/osso-af-init/launch-wrapper-tryrestart.sh
else
  export LAUNCHWRAPPER_NICE=$LAUNCHWRAPPER
  export LAUNCHWRAPPER_NICE_TRYRESTART=$LAUNCHWRAPPER
  export LAUNCHWRAPPER_TRYRESTART=$LAUNCHWRAPPER
fi

# Note: TMPDIR uses flash but UI states are saved to RAM
export TMPDIR=/var/tmp
export STATESAVEDIR=/tmp/osso-appl-states
if [ ! -d $STATESAVEDIR ]; then
  mkdir $STATESAVEDIR
fi

# no existence check because user does not have rights to delete the file
source /etc/osso-af-init/locale

# The MyDocs directory
export MYDOCSDIR=$HOME/MyDocs

# Mount point of the MMC
export MMC_MOUNTPOINT=/media/mmc1 MMC_DEVICE_FILE=/dev/mmcblk0p1
export ILLEGAL_FAT_CHARS=\\\/\:\*\?\<\>\| MAX_FILENAME_LENGTH=255

# this is for Application installer
export User_Applets_Dir=/var/lib/install/usr/share/applications/hildon-control-panel/
