#!/bin/sh

prefix=/usr
sysconfdir=/etc
VAR="$HOME/.hildon-var"
PIDFILE="$VAR/run/dbus/session_bus_pid"
USER=`whoami`
SOCKET="$VAR/run/dbus/socket"
DBUS_DAEMON="/usr/bin/dbus-daemon-1"

mkdir -p $VAR/libosso
mkdir -p $VAR/run/dbus

if [ -e $PIDFILE ]; then
	echo "D-BUS already running; attempting to kill."

	# Scratchbox needs a bit specialties
	if [ -e /targets/links/scratchbox.config ]; then
		echo -n "Running under Scratchbox: CPU transparency method: ";
		source /targets/links/scratchbox.config
		echo $SBOX_CPUTRANSPARENCY_METHOD

		if [ "$SBOX_CPUTRANSPARENCY_METHOD" = "sbrsh" ]; then
			echo -n "We need to run the kill command on the target device: "
			echo $SBOX_TARGET_NAME
			sbrsh $SBOX_TARGET_NAME /bin/kill `cat $PIDFILE`
		else
			echo -n "Not using sbrsh, trying to kill it locally."
			kill -9 `cat $PIDFILE`
		fi
	else
		echo "Not running in Scratchbox, killing it locally."
		kill -9 `cat $PIDFILE`
	fi

	# Just in case... 
	rm -f $PIDFILE
fi

sed s%##HOME##%$HOME%g < ${sysconfdir}/libosso/sessionbus-libosso.conf > $VAR/libosso/sessionbus.conf

${DBUS_DAEMON} --config-file=$VAR/libosso/sessionbus.conf

export DBUS_SESSION_BUS_ADDRESS="unix:abstract=$SOCKET"
export DBUS_SESSION_BUS_PID="`cat $PIDFILE`"
