#!/bin/sh

PIDFILE="/usr/var/run/dbus/pid"
SOCKET="/usr/var/run/dbus/system_bus_socket"

DBUS_DAEMON="/usr/bin/dbus-daemon-1"

case "$1" in
  start)
    if test -e $PIDFILE ; then
      if ! grep dbus /proc/`cat $PIDFILE`/cmdline >/dev/null 2>&1 ; then
        echo "It seems that the D-BUS daemon has crashed. Cleaning up.."
        rm -f $PIDFILE 
        rm -f $SOCKET           
      else
        echo "The dbus daemon is already running"
        exit 1
      fi
    fi
    ${DBUS_DAEMON} --system
    ;;
  stop)
    if test -S "$SOCKET" ; then
      if test -e $PIDFILE ; then
        if grep dbus /proc/`cat $PIDFILE`/cmdline >/dev/null 2>&1 ; then
	  kill `cat $PIDFILE`
	fi
        rm -f $PIDFILE
        rm -f $SOCKET
      fi
    else
      echo "The dbus daemon is not running"
      exit 1
    fi
    ;;
  *)
    echo "Usage: $0 {start|stop}"
    exit 0
    ;;
esac

