/*
 * This file is part of libosso-help-sdk
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "internal.h"

#include <libosso.h>
#include <osso-log.h>
#include <hildon-widgets/hildon-dialoghelp.h>

#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>     // getenv()
#include <stdio.h>      // FILE*

#include <libintl.h>

//  Not waiting for Help UI to give a return value (trying to
//  speed things up on the ARM platform, task xxx)
//
#define RPC_NOWAIT

//---=== Public API ===---

//---( doc in header )---
extern
osso_return_t ossohelp_show( osso_context_t* osso,
                             const char* help_id,
                             guint flags )
{
    
    return OSSO_OK;  
}


/*---( docs in header )
*/
const char *ossohelp_next( h_OssoHelpWalker* h_ref,
                           const char *branch )
{
    return NULL;
}


/**
  Getting a plain text title for either a folder or a topic.
*/
gboolean ossohelp_title( const char *key, char *buf, size_t bufsize )
{
    // TBD: Should handle file ID's ("//helpfile/") separately, 
    //      returning TRUE/FALSE if the file existed.
    
    return TRUE;
}


//---=== Dialog help enabling ===---

// NOTE: code in this section should serve as a sample, or rather,
//       be moved to the HildonDialogHelp codebase (that's where
//       it belongs, so applications don't need to duplicate this)
//
//       Current (w19) 'gtk_dialog_help_enable()' is too low-level.
//
//       If there's a way to pass the 'osso' pointer without giving
//       it as a parameter, that would be fine.

struct s_pair {
    osso_context_t* osso;
    const gchar* topic;
};

static
void on_help( GtkWidget *dialog, gpointer data )
{

}

/*tvh:05-Sep-05
    * This is signal ID for the on_help g_signal_connect to the ? icon
    * For multiple ContextUIDs using the same ? icon in a dialog 
    
    * A good use of this is: A sample_dialog has 2 (even more) TABs tab1 and tab2 
    * Required behaviour:
    *  + when clicking on tab1, clicking ? icon will show help_id_1
    *  + when clicking on tab2, clicking ? icon will show help_id_2

    * Now when handling the event of clicking tab1, this should be called:
        ossohelp_dialog_help_enable( sample_dialog, help_id_1,osso );
    * Similarly, clicking tab2 should invoke this call somewhere
        ossohelp_dialog_help_enable( sample_dialog, help_id_2,osso );

    * Doing this will solve the problem.    

    * TODO: How can we HIDE the ? icon if help_id is incorrect?

*/
gulong sigid = -1;

/*---( docs in header )
*/
gboolean ossohelp_dialog_help_enable( GtkDialog *dialog, 
                                      const gchar *topic,
                                      osso_context_t *osso )
{

    return TRUE;    
}
