/*
 * This file is part of libosso-help-sdk
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OSSO_HELPLIB_INTERNAL_H
#define OSSO_HELPLIB_INTERNAL_H

#include <libosso.h>
#include <osso-log.h>       // ULOG_...()

#include <libxml/parser.h>  // xmlChar

#include "osso-helplib-private.h"   // HELP_KEY_MAXLEN

#define fexists(fn)  g_file_test( fn, G_FILE_TEST_EXISTS )

#define USE_CSS  // do we use CSS decorations

// osso-helplib.c:
//
const gchar *helplib_str_close(void);
const gchar *helplib_str_title(void);

gboolean ossohelp_file2( const char *basename, int basename_len,
                         char *fn_buf, size_t buflen );



#endif  // OSSO_HELPLIB_INTERNAL_H

