import os, sys, re, commands, shutil, random, traceback, gettext
from linda import common
from linda.common import get_source_package_dir, file_to_packagename, dprint, \
    vprint, iterate_dir
from linda.overrides import Overrides
from linda.control import ControlParser
_ = gettext.gettext

class Unpacker:
    def __init__(self):
        self.lab = self.set_up_lab()
        common.options['lab_directory'] = self.lab
        common.output = {'file': {}, 'objdump': {}, 'elf': [], 'ldd': {}, \
            'perms': {}, 'dirs': {}}

    def unpack(self, file, level):
        if not os.path.exists(file):
            raise UnpackException("File doesn't exist, or unreadable")
        if hasattr(self, 'unpack_' + file[-3:] + '_' + repr(level)):
            getattr(self, 'unpack_' + file[-3:] + '_' + repr(level))(file)
        else:
            raise UnpackException("No idea how to unpack %s at level %d" % \
                (file, level))

    def unpack_deb_1(self, file):
        try:
            dprint(_("Unpacking binary, level 1"))
            os.chdir(self.lab)
            exitstat = commands.getstatusoutput('ar x %s' % file)[0]
            self.check_exit(exitstat, 'ar')
            os.unlink('./debian-binary') # For now, anyway.
            os.chdir('./control')
            exitstat, output = commands.getstatusoutput('tar zxvvf \
            ../control.tar.gz')
            self.check_exit(exitstat, 'tar')
            os.unlink('../control.tar.gz')
            controlparse = ControlParser('binary')
            try:
                controlparse.parse()
            except StandardError:
                traceback.print_exc(file=sys.stdout)
                raise UnpackException("control parsing failed.")
            for x in output.split('\n'):
                tmp_array = x.split(' ')
                cur_file = tmp_array[-1]
                if cur_file == './': continue
                common.control_info[cur_file[2:]] = [tmp_array[1], \
                    self.convert_perms(tmp_array[0])]
            dprint(_("Control info: %s.") % common.control_info, 2)
            override = Overrides(file)
            override.parse()
        except EnvironmentError:
            raise UnpackException("Level 1 binary unpacking failed!")

    def unpack_deb_2(self, file):
        try:
            os.chdir(self.lab + '/unpacked')
            dprint(_("Jumping to level 2 (binary)"))
            exitstat, output = commands.getstatusoutput('tar zvvxf \
            ../data.tar.gz')
            self.check_exit(exitstat, 'tar')
            os.unlink('../data.tar.gz')
            file_list = []
            for x in output.split('\n'):
                tmp_array = x.split(' ')
                if tmp_array[-2] == '->':
                    cur_file = tmp_array[-3]
                else:
                    cur_file = tmp_array[-1]
                if tmp_array[-1].endswith('/'):
                    common.output['dirs'][cur_file[:-1]] = [tmp_array[1], \
                        self.convert_perms(tmp_array[0])]
                else:
                    common.output['perms'][cur_file] = \
                        [tmp_array[1], self.convert_perms(tmp_array[0])]
                    file_list.append(cur_file)
            dprint(_("Perms: %s.") % common.output['perms'], 2)
            dprint(_("Directories: %s.") % common.output['dirs'], 2)
            common.files = file_list
            output_list = '\0'.join(file_list).split('\0')
            output_list = self.remove_dups(output_list)
            output_list = self.backwhack(output_list)
            dprint(_("File list: %s") % output_list, 3)
            self.call_file(output_list)
            for x in common.output['file'].keys():
                if (common.output['file'][x].startswith('ELF ') or \
                    common.output['file'][x].find(' ELF ') != -1) and \
                    re.search(r'(executable|shared object|relocatable)', \
                    common.output['file'][x]):
                    common.output['elf'].append(x)
            dprint(_("Spawning off objdump and ldd. (%d object(s).)") % \
                len(common.output['elf']))
            dprint(_("ELF Objects: %s.") % common.output['elf'], 3)
            for x in common.output['elf']:
                dprint(_("Spawning off 'LC_ALL=C objdump -hpT %s'.") % x, 3)
                exitstat, common.output['objdump'][x] = \
                    commands.getstatusoutput('LC_ALL=C objdump -hpT %s' %  x)
                dprint(_("Exit status of objdump: %d") % exitstat, 3)
                if exitstat:
                    print _("objdump exited with a non-zero status. I " +\
                        "suggest installing binutils-multiarch.")
                dprint(_("Spawning off 'LD_LIBRARY_PATH=%s ldd %s'.") % \
                   (self.lab + '/unpacked', x), 3)
                common.output['ldd'][x] = \
                    commands.getstatusoutput('LD_LIBRARY_PATH=%s ldd %s' % \
                        (self.lab + '/unpacked', x))[1]
                dprint(_("Output from ldd: %s") % common.output['ldd'][x], 3)
        except EnvironmentError:
            raise UnpackException("Level 2 binary unpacking failed!")
 
    def unpack_dsc_1(self, file):
        try:
            dprint(_("Unpacking source, level 1"))
            f = open(file)
            if f.read(5) == '-----':
                [f.readline() for i in range(3)]
            else:
                f.seek(0)
            k = f.readline()
            while k != 'Files: \n':
                if k.find(': ') != -1:
                    tmp = k.split(': ')
                    last_field = tmp[0].lower()
                    common.dsc[last_field] = tmp[1][:-1]
                else:
                    common.dsc[last_field] += k[:-1]
                k = f.readline()
            common.dsc['files'] = []
            k = f.readline()[:-1]
            while k != '':
                common.dsc['files'].append(k)
                k = f.readline()[:-1]
            f.close()
            dprint("Parsed .dsc: %s." % common.dsc)
            override = Overrides(file)
            override.parse()
        except EnvironmentError:
            raise UnpackException("Level 1 source unpacking failed!")

    def unpack_dsc_2(self, file):
        os.chdir(self.lab)
        dprint(_("Jumping to level 2 (source)"))
        unparsed_ver = common.dsc['version']
        if unparsed_ver.find('-') != -1:
            version = unparsed_ver[:unparsed_ver.rfind('-')]
        else:
            version = unparsed_ver
        if version.find(':') != -1:
            version = version.split(':')[1]
        dprint(_("Parsed version string: %s.") % version, 2)
        new_directory = common.dsc['source'] + '-' + version
        keeper, throw = os.path.split(file)
        files = []
        for i in common.dsc['files']:
            tmp = i.split(' ')
            if tmp[3].endswith('tar.gz') or tmp[3].endswith('diff.gz'):
                files.append(keeper + '/' + tmp[3])
        for x in files:
            throw, keep = os.path.split(x)
            if x[-11:] == 'orig.tar.gz' or x[-6:] == 'tar.gz':
                dprint(_("Untaring source: %s") % keep)
                output = commands.getstatusoutput('tar zxf %s' % x)
                self.check_exit(output[0], 'tar')
                snapshot_lab = filter(filter_for_src_dir, os.listdir('.'))
                if len(snapshot_lab) == 1:
                    if snapshot_lab[0] != new_directory:
                        dprint(_("Renaming source directory: %s -> %s") % \
                            (snapshot_lab[0], new_directory))
                        os.rename(snapshot_lab[0], new_directory)
                elif len(snapshot_lab) == 0:
                    raise UnpackException("no source files found.")
                else:
                    dprint(_("Creating directory: %s") % new_directory)
                    os.mkdir(new_directory)
                    for y in snapshot_lab:
                        dprint(_("Moving %s into %s") % (y, new_directory))
                        if os.path.isdir(y):
                            shutil.copytree(y, '%s/%s' % (new_directory, y))
                            shutil.rmtree(y)
                        else:
                            shutil.copy(y, new_directory)
            elif x[-7:] == 'diff.gz':
                dprint(_("Applying patch: %s.") % keep)
                exitstat = commands.getstatusoutput('zcat %s | patch ' % x +\
                    '-p0 -g 0 -t -s')
                self.check_exit(exitstat[0], 'patch')
        controlparse = ControlParser('source')
        try:
            controlparse.parse()
        except StandardError:
            traceback.print_exc(file=sys.stdout)
            raise UnpackException("control parsing failed.")
        file_list = filter(file_or_sym, \
            iterate_dir(get_source_package_dir()[0]))
        output_list = '\0'.join(file_list).split('\0')
        output_list = self.remove_dups(output_list)
        output_list = self.backwhack(output_list)
        self.call_file(output_list)

    def check_exit(self, exitstat, command='unknown command'):
        if exitstat != 0:
            raise UnpackException("%s exited with a status of %d" % (command, \
                exitstat))

    def set_up_lab(self):
        for x in (common.options['lab_root'], os.environ.get('TMPDIR'), \
            '/tmp'):
            if x:
                lab_root = x
                break
        lab_directory = "%s/linda-lab-%05d" % (lab_root, \
            random.choice(range(100000)))
        if os.path.exists(lab_directory):
            dprint(_("Lab %s already exists; trying again.") % lab_directory)
            lab_directory = "%s/linda-lab-%05d" % (lab_root, \
                random.choice(range(100000)))
        try:
            os.makedirs(lab_directory + '/control')
            os.mkdir(lab_directory + '/unpacked')
            dprint(_("Creating lab directory: %s.") % lab_directory)
            vprint(_("Creating lab directory: %s.") % lab_directory, 2)
            return lab_directory
        except OSError, e:
            print _("Failed to create lab directory: %s.") % e
            sys.exit(1)

    def cull_lab(self):
        real_cull(self.lab)

    def call_file(self, output_list):
        dprint(_("Spawning off file."))
        file_to_run = []
        y = ''
        sh_limit = 65535
        for x in output_list:
            if len(y) + len(x) < sh_limit:
                y += '"' + x + '"' + ' '
            else:
                file_to_run.append(y)
                y = '"' + x + '"' + ' '
        else:
            if len(y) + len(x) < sh_limit:
                y += '"' + x + '"'
                file_to_run.append(y)
            else:
                file_to_run.append(x)
        output_file = ''
        for x in range(len(file_to_run)):
            exitstat, tmp_out = commands.getstatusoutput('file %s' % \
                file_to_run[x])
            dprint(_("Running: file %s") % file_to_run[x], 3)
            self.check_exit(exitstat, ('iteration %d of file' % x))
            output_file += tmp_out + '\n'
        for x in output_file.split('\n'):
            cur_line = re.split(': +', x)
            if cur_line[0] == '':
                continue
            if len(cur_line) == 2:
                common.output['file'][cur_line[0]] = cur_line[-1]
            else:
                common.output['file'][cur_line[0]] = \
                    ': '.join(cur_line[1:])
        dprint(_("Output from file: %s.") % common.output['file'], 3)

    def convert_perms(self, str):
        tmp_perm = [str[0], str[1:4], str[4:7], str[7:]]
        perm_str = [0, 0, 0, 0]
        for x in range(1, 4):
            for y in tmp_perm[x]:
                if y == 'r': perm_str[x] += 4
                if y == 'w': perm_str[x] += 2
                if y == 'x': perm_str[x] += 1
                if y in ('s', 'S') and x in (1, 2):
                    if x == 1: perm_str[0] += 4
                    if x == 2: perm_str[0] += 2
                    if y == 's': perm_str[x] += 1
                if y in ('t', 'T') and x == 3:
                    perm_str[0] += 1
                    if y == 't': perm_str[3] += 1
        return "%d%d%d%d" % tuple(perm_str)

    def remove_dups(self, output_list):
        single_output_list = []
        for x in output_list:
            if x not in single_output_list:
                single_output_list.append(x)
        return single_output_list

    def backwhack(self, output_list):
        for x in range(len(output_list)):
                output_list[x] = output_list[x].replace('$', '\$')
        return output_list
    
class UnpackException(Exception):
    pass

def file_or_sym(x):
    if os.path.isfile(x) or os.path.islink(x):
        return 1
    else:
        return 0

def filter_for_src_dir(data):
    if data in ('unpacked', 'control'):
        return 0
    else:
        return 1

def real_cull(lab):
    # So I don't have to duplicate lab cleaning code.
    if not common.options['no_cull']:
        try:
            shutil.rmtree(lab)
        except OSError:
            print _("Failed to remove lab directory: %s") % lab
        dprint(_("Removing lab directory: %s.") % lab)
        vprint(_("Removing lab directory: %s.") % lab, 2)

