import os, re, commands, gettext
from linda import common
from linda.common import file_to_packagename, dprint
_ = gettext.gettext

class Overrides:
    def __init__(self, file):
        self.file = file
        self.pkg_name = file_to_packagename(file)
        self.files_to_read = []
        
    def clear(self):
        common.overrides.clear()

    def parse(self):
        self.clear()
        self.parse_overrides()
        throw, ext = os.path.splitext(self.file)
        if ext in ('.deb', '.udeb'):
            self.parse_indeb()
        self.print_overrides()
        
    def parse_overrides(self):
        files_to_look = [common.linda_root + '/overrides/', \
            '/etc/linda/overrides/', os.path.expanduser('~/.linda/overrides/')]
        if common.options['config']:
            files_to_look.append(common.options['config'] + '/overrides/')
        for x in files_to_look:
            try:
                f = open(x + 'all')
                self.files_to_read.append(f)
            except EnvironmentError:
                dprint(_("Failed to open %s.") % (x + 'all'))
            try:
                f = open(x + self.pkg_name)
                self.files_to_read.append(f)
            except EnvironmentError:
                dprint(_("Failed to open %s.") % (x + self.pkg_name))
        if common.options['more_overrides']:
            f = open(common.options['more_overrides'])
            self.files_to_read.append(f)
        for x in self.files_to_read:
            dprint(_("Parsing overrides from %s") % x.name)
            self.parse_file(x.xreadlines())
            x.close()
        
    def parse_file(self, fileobj):
        for x in fileobj:
            if x == '':
                continue
            if x.split(': ')[0] not in ('Tag', 'Data', 'Type') and x != '\n':
                dprint(_("Ignoring unknown line \"%s\".") % x[:-1])
                continue
            if x.endswith('\n'):
                x = x[:-1]
            if x.startswith('Tag:'):
                tag = x.split(': ')[1].strip()
                common.overrides[tag] = {}
            if x.startswith('Data:') and tag != '':
                common.overrides[tag]['data'] = \
                    x.split(': ')[1].split(' ')
            if x.startswith('Type:') and tag != '':
                common.overrides[tag]['type'] = \
                    x.split(': ')[1].strip()
            if x == '\n':
                tag = ''

    def parse_indeb(self):
        os.chdir(common.options['lab_directory'])
        if os.path.exists('data.tar.gz'):
            exitstat, override_out = commands.getstatusoutput('tar zxf '+\
                'data.tar.gz ./usr/share/linda/overrides/%s -O' % \
                self.pkg_name)
        or_lst = override_out.split('\n')
        if not exitstat:
            dprint(_("Parsing in-deb overrides."))
            self.parse_file(or_lst)
        else:
            dprint(_("Failed to open in-deb overrides."))
    
    def print_overrides(self):
        if common.options['print_over']:
            print _("Overrides: %s") % common.overrides
        else:
	    dprint(_("Overrides: %s") % common.overrides)

def check_overrides(errs, output_var, tag):
    override = 0
    to_del = []
    if not common.overrides[tag] or not common.overrides[tag].has_key('data'):
        if common.overrides[tag].has_key('type'):
            dprint(_("Overriding Type of %s to %s") % (x, \
                common.overrides[tag]['type']))
            output_var['type'] = common.overrides[tag]['type']
        else:
            override = 1
    else:
        for y in common.overrides[tag]['data']:
            for error in errs:
                for rdata in error:
                    dprint(_("Checking %s against %s ...") % (rdata, y), 2, 0)
                    if re.search(y, rdata) or re.search(rdata, y):
                        dprint(_("True!"), 2, printd=0)
                        if common.overrides[tag].has_key('type'):
                            dprint(_("Overriding Type of %s with data of " +\
                                "%s to %s") % (tag, rdata, \
                                common.overrides[tag]['type']))
                            output_var['Type'] = common.overrides[tag]['type']
                        else:
                            try:
                                to_del.index(error)
                                dprint(_("Not appending %s to to_del.") % \
                                    error, 2)
                            except ValueError:
                                to_del.append(error)
                                dprint(_("Appending %s to to_del.") % error, 2)
                    else:
                        dprint(_("Untrue!"), 2, printd=0)
    dprint(_("Processing done: to_del: %s.") % to_del, 2)
    if override:
        dprint(_("Wimping out of printing %s") % tag)
        return 1
    for y in to_del:
        dprint(_("Not printing tag %s with data %s.") % (tag, y))
        errs.remove(y)
    

