import sys, os, gettext, traceback
from linda import common
_ = gettext.gettext

class Output:
    def __init__(self):
        self.check_type = self.tag = self.pkg_name = self.desc_str = ''
        self.level = 0
    
    def create_vars(self, err_tuple):
        (self.tag, self.data, self.output_var, self.pkg_name, \
            self.desc_str) = err_tuple
        self.type = self.output_var['Type']
        self.type_char = type_single_char(self.type)
        self.change_exit_status()
    
    def add_type(self, type, level):
        self.check_type = type
        self.level = level

    def change_exit_status(self):
        if self.type_char == 'W' and common.exit_status == 0:
            common.exit_status = 1
        if self.type_char == 'E' and common.exit_status < 2:
            common.exit_status = 2

registry = {}

def type_single_char(type_str):
    for x in type_str:
        if x.isupper():
            return x

def show_error(format, err_tuple):
    common.out_class.create_vars(err_tuple)
    common.out_class.output()

def register(klass, tag):
    registry[tag] = klass

def register_all(dir):
    for file in os.listdir(dir):
        file = os.path.join(dir, file)
        if file.endswith('.py'):
            try:
                execfile(file, {'_': gettext.gettext})
            except StandardError:
                print _("Failed to import %s.") % file
                traceback.print_exc(file=sys.stdout)

