import re, gettext
from linda import common
from linda.common import dprint, get_source_package_dir
_ = gettext.gettext

class ControlParser:
    def __init__(self, type):
        self.type = type
        if type == 'binary':
            self.isbinary = 1
            self.issource = 0
        elif type == 'source':
            self.isbinary = 0
            self.issource = 1
            
    def clear(self):
        if self.isbinary:
            common.control = {}
        elif self.issource:
            common.control = []
        common.control_info = {}

    def parse(self):
        self.clear()
        dprint(_("Parsing %s control file.") % self.type)
        if self.isbinary:
            con_file = common.options['lab_directory'] + '/control/control'
        elif self.issource:
            con_file = get_source_package_dir()[0] + '/debian/control'
        try:
            f = open(con_file)
        except IOError, e:
            dprint(_("Failed to open control file: %s") % e)
            raise IOError, "control file doesn't exist"
        if f:
            if self.isbinary:
                # A binary control file is just one chunk.
                self.parse_chunk(f.read())
                f.close()
                common.control = self.cur_chunk
            elif self.issource:
                k = f.read()
                # Split into stanzas.
                tmp_chunks = k.split('\n\n')
                f.close()
                for x in tmp_chunks:
                    self.parse_chunk(x)
                    common.control.append(self.cur_chunk)
            dprint(_("Complete control file: %s") % common.control, 3)
    
    def parse_chunk(self, fp):
        self.cur_chunk = {}
        for y in fp.split('\n'):
            if y.startswith(' '):
                # Extended description
                if self.cur_chunk.has_key('ex-desc') and y != ' .\n':
                    self.cur_chunk['ex-desc'] += y
                else:
                    self.cur_chunk['ex-desc'] = y
            elif y.split(': ')[0].lower() in ('depends', 'pre-depends', \
                'provides', 'replaces', 'conflicts', 'build-depends', \
                'recommends', 'build-depends-indep', 'suggests'):
                cur_type = y.split(': ')[0].lower()
                dppr_line = y.split(': ')[1].split(',')
                for z in dppr_line:
                    if z.find('|'):
                        split_deps = z.split('|')
                        for aa in split_deps:
                            self.add_to_hash(cur_type, aa)
                    else:                    
                        self.add_to_hash(cur_type, z)
            else:
                split_line = y.split(': ')
                if len(split_line) == 2:
                    self.cur_chunk[split_line[0].lower()] = split_line[1].strip()
                elif len(split_line) > 2:
                    self.cur_chunk[split_line[0].lower()] = ': '.\
                        join(split_line[1:])
                    self.cur_chunk[split_line[0].lower()] = self.cur_chunk\
                        [split_line[0].lower()]
        dprint(_("Current chunk: %s") % self.cur_chunk, 2)

    def add_to_hash(self, cur_type, cur_line):
        end_pkg = 0
        cur_ver = cur_arch = ''
        if not self.cur_chunk.has_key(cur_type):
            self.cur_chunk[cur_type] = {}
        cur_line = cur_line.strip()
        if cur_line.find('(') != -1:
            cur_ver = cur_line[cur_line.find('(')+1:cur_line.find(')')]
        if cur_line.find('[') != -1:
            cur_arch = cur_line[cur_line.find('[')+1:cur_line.find(']')]
        if cur_ver:
            cur_pkg = cur_line[:cur_line.find('(')]
            end_pkg = 1
        if cur_arch and not end_pkg:
            cur_pkg = cur_line[:cur_line.find('[')]
            end_pkg = 1
        if not end_pkg:
            cur_pkg = cur_line
        cur_pkg = cur_pkg.strip()
        self.cur_chunk[cur_type][cur_pkg] = []
        if cur_ver:
            match_obj = re.search(r'([0-9]|\$)', cur_ver)
            first_num = match_obj.start()
            cur_compare = cur_ver[:first_num]
            cur_compare = cur_compare.strip()
            self.cur_chunk[cur_type][cur_pkg].append(cur_compare)
            self.cur_chunk[cur_type][cur_pkg].append(cur_ver[first_num:])
        if cur_arch:
            self.cur_chunk[cur_type][cur_pkg].append(cur_arch.split(' '))

