import sys, os, re, stat, gettext, locale
_ = gettext.gettext

exit_status = 0 
options = {'no_cull': 0, 'lab_root': '', 'check_string': '', \
'files': [], 'unpack_level': 0, 'printtrace': 0, 'informational': 0, \
'format': '', 'list_checks': 0, 'info': 0, 'show_tag': 0, 'override_over': 0, \
'verbose': 0, 'lang': '', 'lab_directory': '', 'archs': [], 'config': '', \
'print_over': 0, 'debug': 0, 'more_overrides': ''}
out_class = None
control = None
control_info = {}
overrides = {}
dsc = {}
linda_root = ''

def get_source_package_dir():
    cur_dir = []
    if os.path.isdir(options['lab_directory']):
        for x in os.listdir(options['lab_directory']):
            if os.path.isdir(options['lab_directory'] + '/' + x) and x not \
                in ('control', 'unpacked'):
                cur_dir.append(x)
    return cur_dir

file_to_packagename = lambda file: os.path.split(file)[-1].split('_')[0]

file_to_version = lambda file: os.path.split(file)[-1].split('_')[1]

def iterate_dir(directory):
    tmp_file = []
    os.path.walk(directory, add_file, tmp_file)
    return tmp_file

def add_file(arg, dirname, names):
    for x in names:
        if os.path.isfile(dirname + '/' + x):
            arg.append(dirname + '/' + x)

def get_dir(directory):
    tmp_file = []
    os.path.walk(directory, add_dir, tmp_file)
    return tmp_file

def add_dir(arg, dirname, names):
    for x in names:
        if os.path.isdir(dirname + '/' + x):
            arg.append(dirname + '/' + x)

def aps_not_valid(type, data):
    dprint(_("Aps_not_valid called: [%s, %s].") % (type, data), 2)
    if type == 'arch':
        if data[0] == '!':
            data = data[1:]
        dprint(_("Arches: %s.") % options['archs'], 2)
        if data not in options['archs']:
            return 1
        else:
            return 0
    elif type == 'priority':
        if data not in ('required', 'important', 'standard', 'optional', \
            'extra'):
            return 1
        else:
            return 0
    elif type == 'section':
        if data not in ('admin', 'base', 'comm', 'contrib', 'devel', \
            'debian-installer', 'doc', 'editors', 'electronics', 'embedded', \
            'games', 'gnome', 'graphics', 'hamradio', 'interpreters', 'kde', \
            'libdevel', 'libs', 'mail', 'main', 'math', 'misc', 'net', \
            'news', 'non-US', 'non-free', 'oldlibs', 'otherosfs', 'perl', \
            'python', 'science', 'shells', 'sound', 'tex', 'text', 'utils', \
            'web', 'x11'):
            return 1
        else:
            return 0
    elif type == 'essential':
        if data not in ('ncurses-base', 'textutils', 'bsdutils', 'sed', \
            'base-passwd', 'util-linux', 'ncurses-bin', 'tar', 'gzip', \
            'dpkg', 'base-files', 'findutils', 'shellutils', 'grep', \
            'mount', 'e2fsprogs', 'sysvinit', 'perl-base', 'hostname', \
            'fileutils', 'login', 'diff', 'bash', 'debianutils'):
            return 1
        else:
            return 0
    else:
        return 0

def set_up_locale():
    # Set the locale, based on the environment
    try:
        locale.setlocale(locale.LC_ALL, "")
    except locale.Error, e:
        print _("Failed to set the locale: %s") % e
    # Rip out the message locale
    options['lang'] = locale.setlocale(locale.LC_MESSAGES).split('_')
    if len(options['lang']) == 1 and \
        os.path.exists('/usr/share/locale/locale.alias'):
        f = open('/usr/share/locale/locale.alias')
        for x in f.xreadlines():
            if x.startswith(options['lang'][0]):
                cur_line = re.split(r'\s+', x)
                options['lang'] = cur_line[1].split('_')
                break
        f.close()
    if len(options['lang']) > 1:
        if options['lang'][1].find('@') != -1:
            char = '@'
        elif options['lang'][1].find('.') != -1:
            char = '.'
        else:
            char = ''
        if char:
            tmp_array = options['lang'][1].split(char)
            tmp_array.insert(1, char)
            options['lang'] = options['lang'] + tmp_array
            del options['lang'][1]

def dprint(msg, level=1, slashn=1, printd=1):
    if options['debug'] >= level:
        if printd:
            print _("D:"),
        if slashn:
            print msg
        else:
            print msg,

def vprint(msg, level):
    if options['verbose'] >= level and not (level == 2 and options['debug']):
        print _("V:"),
        print msg

