from linda import checks, common

class UDebControlCheck(checks.LindaChecker):
    def check_udeb_1(self):
        if common.control.has_key('section'):
            if common.control['section'] != 'debian-installer':
                self.signal_error('section-not-di')
        else:
            dprint(_("No Section header."))
        if common.control.has_key('priority'):
            if aps_not_valid('priority', common.control['priority']):
                self.signal_error('unknown-priority', \
                    [common.control['priority']])
        else:
            dprint(_("No Priority header."))

checks.register(UDebControlCheck)

