from linda import checks, common

class UDebBinaryCheck(checks.LindaChecker):
    def check_udeb_2(self):
        os.chdir('./unpacked')
        if common.control.has_key('architecture'):
            arch = common.control['architecture']
        else:
            arch = 'none'
        if os.path.exists('./usr/share/doc'):
            self.signal_error('u-s-d-in-udeb')
        if os.path.exists('./usr/share/man'):
            self.signal_error('u-s-m-in-udeb')
        if os.path.exists('./usr/local'):
            self.signal_error('u-l-in-udeb')
        if common.output['elf'] and arch == 'all':
            self.signal_error('udeb-pkg-should-be-arch-any')
        if common.control.has_key('description'):
            if common.control['description'].find(',') != -1:
                self.signal_error('comma-in-short-desc')
        for x in common.files:
            path, throw = os.path.split(x[1:])
            if path == '/usr/share':
                self.signal_error('file-in-u-s')
            if x.find('/CVS/') != -1:
                self.signal_error('cvs-dir-in-udeb')
            if x.find('./usr/doc') != -1:
                self.signal_error('usr-doc-in-udeb')

checks.register(UDebBinaryCheck)

